import yt.wrapper as yt
import time
import datetime
from datetime import date, datetime, timedelta
import argparse
import urllib2

def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--timestamp', help='date timestamp for calculation')
    parser.add_argument('--from_date', help='from date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--to_date', help='to date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    args = parser.parse_args()
    return args

def get_dates(timestamp, from_date, to_date):
    dates = []
    date_format = '%Y-%m-%d'
    if timestamp:
        date = datetime.fromtimestamp(int(timestamp[:10]))
        dates.append(date.strftime(date_format))
    if from_date and not to_date:
        to_date = datetime.strftime(datetime.now(), date_format)
    if from_date and to_date:
        current_date = datetime.strptime(from_date, date_format)
        while current_date <= datetime.strptime(to_date, date_format):
            dates.append(current_date.strftime(date_format))
            current_date += timedelta(1)
    return dates

IP_TO_COUNTRY_NAME_MAP = {
    225: "Ru",
    187: "Ua",
    149: "By",
    159: "Kz",
    983: "Tr",
    171: "Uz",
    170: "Tm",
    209: "Tj",
    168: "Am",
    167: "Az",
    169: "Ge",
    207: "Kg",
    208: "Md"
}


def get_country_name(ip):
    return IP_TO_COUNTRY_NAME_MAP.get(ip)


def push_to_razladki(outputTable):
    avgMetrics = 0.
    date = str(outputTable).split('/')[-1]
    timestamp = time.mktime(time.strptime(date, '%Y-%m-%d'))
    print timestamp
    for row in yt.read_table(outputTable, raw = False):
        reg = get_country_name(row["ip"])
        srv = row["service"]
        for key in row.keys():
            try:
                if key == "ip" or key == "service" or row[key] is None or row["total"] < 1000:
                    continue
                avgMetrics = row[key]
                if key.endswith("_%"):
                    key = key + '25'
                avgName = srv + "_" + reg + "_" + key
                razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("suggest_metrics_avrg_time_per_symbol", avgName, avgMetrics, timestamp)
                print avgName, avgMetrics
                print urllib2.urlopen(razladkiUrl).read()
            except:
                time.sleep(300)

if __name__ == '__main__':
    args = parse_args()
    dates = get_dates(args.timestamp, args.from_date, args.to_date)
    print dates
    for date in dates:
        outputTable = '//home/suggest-dev/galamaj/suggest_metrics/time_per_symb/all_srv/' + date
        push_to_razladki(outputTable)

