# coding=utf-8

import requests
import json
import yt.wrapper as yt
import sys
import time
import datetime
from datetime import date, datetime, timedelta
import argparse


IP_TO_COUNTRY_NAME_MAP = {
    225: "Ru",
    187: "Ua",
    149: "By",
    159: "Kz",
    983: "Tr",
    171: "Uz",
    170: "Tm",
    209: "Tj",
    168: "Am",
    167: "Az",
    169: "Ge",
    207: "Kg",
    208: "Md"
}


def get_country_name(ip):
    return IP_TO_COUNTRY_NAME_MAP.get(ip)

def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--timestamp', help='date timestamp for calculation')
    parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    parser.add_argument('--stat_user', help="token for Statistics")
    args = parser.parse_args()
    return args

def get_dates(timestamp, from_date, to_date):
    dates = []
    date_format = '%Y-%m-%d'
    if timestamp:
        date = datetime.fromtimestamp(int(timestamp[:10]))
        dates.append(date.strftime(date_format))
    if from_date and not to_date:
        to_date = datetime.strftime(datetime.now(), date_format)
    if from_date and to_date:
        current_date = datetime.strptime(from_date, date_format)
        while current_date <= datetime.strptime(to_date, date_format):
            dates.append(current_date.strftime(date_format))
            current_date += timedelta(1)
    return dates


def read_data(date):
    inputTable = '//home/suggest-dev/galamaj/suggest_metrics/time_per_symb/all_srv/' + date
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    platform = None
    for row in yt.read_table(inputTable):
        d = {}
        if row['service'] is None or row["service"] == "market-touch":
            continue
        if row['service'].find("market") == -1:
            continue
        reg = get_country_name(row["ip"])
        if row['service'] == "market":
            platform = "desktop"
        if row['service'] == "market-touch-node":
            platform = "touch"
        if row['service'] == "market-touch-x5":
            platform = "touch_x5"
        if row['service'] == "market_app_android":
            platform = "app_android"
        if row['service'] == "market_app_android_pad":
            platform = "app_android_pad"
        if row['service'] == "market_app_ios":
            platform = "app_ios"
        if row['service'] == "market_app_ios_pad":
            platform = "app_ios_pad"
        if reg is not None and platform is not None:
            d['fielddate'] = date
            d['platform'] = "\tplatform\t" + platform + "\t" + reg + "\t"
            if type(row["used_%"]) == list:
                d['used'] = str(row["used_%"][0].split("\t")[1])
            else:
                d['used'] = str(row["used_%"])
            d['total_queries'] = str(row["total"])
            d['avrg_query_length_normalized'] = str(row["avrg_query_length_normalized"])
            d['avrg_time_per_symb_sfc'] = str(row["avrg_time_per_symb_sfc"])
            d['avrg_time_per_symb_tit'] = str(row["avrg_time_per_symb_tit"])
            d['avrg_normalized_time_sfc'] = str(row["avrg_normalized_time_sfc"])
            d['avrg_normalized_time_tit'] = str(row["avrg_normalized_time_tit"])
            d['used_avrg_time_per_symb_sfc'] = str(row["used_avrg_time_per_symb_sfc"])
            d['used_avrg_time_per_symb_tit'] = str(row["used_avrg_time_per_symb_tit"])
            d['used_avrg_normalized_time_sfc'] = str(row["used_avrg_normalized_time_sfc"])
            d['used_avrg_normalized_time_tit'] = str(row["used_avrg_normalized_time_tit"])
            d['used_avrg_query_length_normalized'] = str(row["used_avrg_query_length_normalized"])
            d['median_input_time_sfc'] = str(row["median_input_time_sfc"])
            d['median_input_time_tit'] = str(row["median_input_time_tit"])
            d['used_median_input_time_sfc'] = str(row["used_median_input_time_sfc"])
            d['used_median_input_time_tit'] = str(row["used_median_input_time_tit"])
            d['zero_sfc'] = str(row["zero_sfc_%"])
            d['zero_tit'] = str(row["zero_tit_%"])
            d['fulltext_clicks'] = str(row["fulltext_clicks"])
            d['empty_pref_history_clicks'] = str(row["empty_pref_history_clicks"])
            d['empty_pref_history_part_in_fulltext'] = str(row["empty_pref_history_part_in_fulltext"])
            d['empty_pref_history_part_in_total'] = str(row["empty_pref_history_part_in_total"])
            d['fulltext_avrg_normalized_time_sfc'] = str(row["fulltext_avrg_normalized_time_sfc"])
            d['fulltext_avrg_normalized_time_tit'] = str(row["fulltext_avrg_normalized_time_tit"])
            d['history_avrg_normalized_time_sfc'] = str(row["history_avrg_normalized_time_sfc"])
            d['history_avrg_normalized_time_tit'] = str(row["history_avrg_normalized_time_tit"])
            d['fulltext_part'] = str(row["fulltext_part"])
            try:
                d['not_shown'] = str(row["not_shown_%"])
                d['suggest_coverage'] = str(row["suggest_coverage_%"])
                d['used_from_total'] = str(row["used_from_total_%"])
                d['mouse_keyboard'] = str(row["mouse_keyboard"])
            except KeyError:
                pass
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data


def post_to_stat(data, token, scale='d', beta = False, _append_mode=1):
    '''data is dict of values :
    data = [
                {'fielddate': '2015-02-03', 'project': 'Portal', 'name': '400', 'field1': 99},
                {'fielddate': '2015-02-03', 'project': 'Morda', 'name': '400', 'field1': 30},
                {'fielddate': '2015-02-04', 'project': 'Portal', 'name': '400', 'field1': 19},
                {'fielddate': '2015-02-04', 'project': 'Morda', 'name': '400', 'field1': 102},
            ]
    '''
    name = '/Market/Others/Suggest_metrics'
    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers = {
            'Authorization' : 'OAuth ' + token
        },
        data={
            'name': name,
            'scale': scale,
            'json_data': json.dumps({'values': data}),
            '_append_mode':_append_mode
        },
    )
    return r.text

if __name__ == '__main__':
    args = parse_args()
    for date in sys.stdin:
        print date
        date = date.rstrip("\n")
        data = read_data(date)
        print data
        push_to_stat = post_to_stat(data, args.stat_user)
        print push_to_stat

