import yt.wrapper as yt
import time
import datetime
from datetime import date, datetime, timedelta
import argparse
import urllib2
import sys

def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--timestamp', help='date timestamp for calculation')
    parser.add_argument('--from_date', help='from date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--to_date', help='to date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    args = parser.parse_args()
    return args

def get_dates(timestamp, from_date, to_date):
    dates = []
    date_format = '%Y-%m-%d'
    if timestamp:
        date = datetime.fromtimestamp(int(timestamp[:10]))
        dates.append(date.strftime(date_format))
    if from_date and not to_date:
        to_date = datetime.strftime(datetime.now(), date_format)
    if from_date and to_date:
        current_date = datetime.strptime(from_date, date_format)
        while current_date <= datetime.strptime(to_date, date_format):
            dates.append(current_date.strftime(date_format))
            current_date += timedelta(1)
    return dates

IP_TO_COUNTRY_NAME_MAP = {
    225: "Ru",
    187: "Ua",
    149: "By",
    159: "Kz",
    983: "Tr",
    171: "Uz",
    170: "Tm",
    209: "Tj",
    168: "Am",
    167: "Az",
    169: "Ge",
    207: "Kg",
    208: "Md"
}


def get_country_name(ip):
    return IP_TO_COUNTRY_NAME_MAP.get(ip)


def push_to_razladki_NEW(outputTable, date):
    avgMetrics = 0.
    timestamp = time.mktime(time.strptime(date, '%Y-%m-%d'))
    print timestamp
    for row in yt.read_table(outputTable, raw = False):
        try:
            reg = get_country_name(row["ip"])
            srv = row["service"]
            if row["total"] < 1000:
                continue
            avgName = srv + "_" + reg + "_NEW_100"
            avgMetrics = 100.
            razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("suggest_technical_metrics_all_srv", avgName, avgMetrics, timestamp)
            print avgName, avgMetrics
            print urllib2.urlopen(razladkiUrl).read()
            avgName = srv + "_" + reg + "_NEW_empty_response_from_suggest"
            avgMetrics = float(row["empty_responses_from_suggest"])/float(row["requests_to_suggest"])*100
            razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("suggest_technical_metrics_all_srv", avgName, avgMetrics, timestamp)
            print avgName, avgMetrics
            print urllib2.urlopen(razladkiUrl).read()
            avgName = srv + "_" + reg + "_NEW_rendered_suggest"
            avgMetrics = (float(row["empty_responses_from_suggest"])+float(row["rendered_suggest"]) + float(row["late_response"]))/float(row["requests_to_suggest"])*100
            razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("suggest_technical_metrics_all_srv", avgName, avgMetrics, timestamp)
            print avgName, avgMetrics
            print urllib2.urlopen(razladkiUrl).read()
            avgName = srv + "_" + reg + "_NEW_suggest_server_coverage"
            avgMetrics = (float(row["responses_from_suggest"])-float(row["empty_responses_from_suggest"]))/float(row["requests_to_suggest"])*100
            razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("suggest_technical_metrics_all_srv", avgName, avgMetrics, timestamp)
            print avgName, avgMetrics
            print urllib2.urlopen(razladkiUrl).read()
            avgName = srv + "_" + reg + "_NEW_late_response"
            avgMetrics = (float(row["empty_responses_from_suggest"]) + float(row["late_response"]))/float(row["requests_to_suggest"])*100
            razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("suggest_technical_metrics_all_srv", avgName, avgMetrics, timestamp)
            print avgName, avgMetrics
            print urllib2.urlopen(razladkiUrl).read()
        except:
                time.sleep(300)

def push_to_razladki(outputTable, date):
    avgMetrics = 0.
    timestamp = time.mktime(time.strptime(date, '%Y-%m-%d'))
    print timestamp
    for row in yt.read_table(outputTable, raw = False):
        reg = get_country_name(row["ip"])
        srv = row["service"]
        for key in row.keys():
            try:
                if key == "ip" or key == "service" or row[key] is None or row["total"] < 1000:
                    continue
                else:
                    avgMetrics = row[key]
                    avgName = srv + "_" + reg + "_" + key
                    razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("suggest_technical_metrics_all_srv", avgName, avgMetrics, timestamp)
                    print avgName, avgMetrics
                    print urllib2.urlopen(razladkiUrl).read()
            except:
                time.sleep(300)


if __name__ == '__main__':
    # dates = ['2018-11-05', '2018-11-08'] #, '2018-08-03', '2018-08-05', '2018-08-06', '2018-08-04','2018-08-08', '2018-08-09', '2018-08-07', '2018-08-11', '2018-08-12', '2018-08-10', '2018-08-13', '2018-08-14', '2018-08-15', '2018-08-16', '2018-08-17', '2018-08-18', '2018-08-19', '2018-08-20', '2018-08-21', '2018-08-22', '2018-08-23', '2018-08-24', '2018-08-25', '2018-08-26', '2018-08-27', '2018-08-28', '2018-08-29', '2018-08-30', '2018-08-31']
    for date in sys.stdin:
        date  = date.rstrip("\n")
    # for date in dates:
    #     print date
    # args = parse_args()
    # dates = get_dates(args.timestamp, args.from_date, args.to_date)
    # print dates
    # for date in dates:
        print date
        outputTable = '//home/suggest-dev/galamaj/suggest_metrics/technical_metrics/' + date
        push_to_razladki(outputTable, date)
        push_to_razladki_NEW(outputTable, date)
        # push_to_suggest_world_kpi(outputTable, date)

