#!/usr/bin/python
# -*- coding: utf-8 -*-

import yt.wrapper
import sys
import urlparse
import re
import urllib
import urllib2
import json
import threading
import sys
import time
import datetime
from datetime import date, datetime, timedelta
import argparse


def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--timestamp', help='date timestamp for calculation')
    parser.add_argument('--from_date', help='from date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--to_date', help='to date for calculation (format: YYYY-MM-DD)')
    # parser.add_argument('--query', default='', help='MR server (hahn, banach, ...)')
    # parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    args = parser.parse_args()
    return args

def get_dates(timestamp, from_date, to_date):
    dates = []
    date_format = '%Y-%m-%d'
    if timestamp:
        date = datetime.fromtimestamp(int(timestamp[:10]))
        dates.append(date.strftime(date_format))
    if from_date and not to_date:
        to_date = datetime.strftime(datetime.now(), date_format)
    if from_date and to_date:
        current_date = datetime.strptime(from_date, date_format)
        while current_date <= datetime.strptime(to_date, date_format):
            dates.append(current_date.strftime(date_format))
            current_date += timedelta(1)
    return dates


def push_to_razladki(outputTable):
    inputTable = '//home/suggest-dev/suggest/galamaj/suggest_metrics/unique_queries/touch_' + date
    avgMetric = 0.
    date = str(inputTable).split('/')[-1].split('_')[-1]
    timestamp = time.mktime(time.strptime(date, '%Y-%m-%d'))
    print timestamp
    for row in yt.wrapper.read_table(inputTable, raw = False):
        for key in row.keys():
            if row["text"] == "вконтакте":#.decode('utf-8') == u"вконтакте":
                if type(row[key]) == str:
                    continue
                avgName = "vkontakte_" + key
                avgMetrics = float(row[key])
                razladkiUrl = 'http://launcher.razladki.yandex-team.ru/save_new_data/%s?%s=%s&ts=%s&override=1' % ("suggest_metrics_unique_queries", avgName, avgMetrics, timestamp)
                print avgName, avgMetrics
                print urllib2.urlopen(razladkiUrl).read()

if __name__ == '__main__':
    args = parse_args()
    dates = get_dates(args.timestamp, args.from_date, args.to_date)
    print dates
    for date in dates:
        push_to_razladki(date)
