import math
import urllib
import json
from datetime import datetime, date, time,timedelta

DATA_URL = 'https://razladki.yandex-team.ru/api/sitelinks/plot_data?ts_from=%s&ts_to=%s&param=%s'

class TRazladkiStats:
    def __init__(self, name, end_date, delta):
        self.ts_from, self.ts_to = self.__dates(end_date, delta)
        self.bna_kpi = self.__fetch('desktop_ru_BNA_kpi_uniq_%s' % name)
        self.bna_top = self.__fetch('desktop_ru_BNA_top_uniq_%s' % name)
        self.bna_stream = self.__fetch('desktop_ru_BNA_stream_uniq_%s' % name)
        self.s_kpi = self.__fetch('desktop_ru_sitelinks_kpi_uniq_%s' % name)
        self.s_top = self.__fetch('desktop_ru_sitelinks_top_uniq_%s' % name)
        self.s_stream = self.__fetch('desktop_ru_sitelinks_stream_uniq_%s' % name)

    @staticmethod
    def __dates(end_date, delta):
        ts_to = end_date
        ts_from = ts_to - timedelta(days=delta)
        return ts_from, ts_to

    @staticmethod
    def __average(data):
        return math.fsum(data) / len(data)

    @staticmethod
    def __stddev(data):
        ave = TRazladkiStats.__average(data)
        return math.sqrt(math.fsum([math.pow(x - ave, 2) for x in data]) / (len(data) - 1))

    def __fetch(self, param):
        url = DATA_URL % (urllib.quote_plus(self.ts_from.strftime('%Y-%m-%d %H:%M:%S')),
                          urllib.quote_plus(self.ts_to.strftime('%Y-%m-%d %H:%M:%S')),
                          param)
        data = json.load(urllib.urlopen(url))
        if param not in data:
            raise ValueError('No data key %s in razladki plots' % param)
        result = list()
        for plot in data[param]:
            result.append(plot[1])
        return result

    def get_kpi_deviation(self):
        return self.__stddev(self.bna_kpi)

    def get_top_deviation(self):
        return self.__stddev(self.bna_top)

    def get_stream_deviation(self):
        return self.__stddev(self.bna_stream)

    def get_kpi_deviation_s(self):
        return self.__stddev(self.s_kpi)

    def get_top_deviation_s(self):
        return self.__stddev(self.s_top)

    def get_stream_deviation_s(self):
        return self.__stddev(self.s_stream)

def main():
    DATES = [date(2016, 03, 01),
             date(2016, 04, 01),
             date(2016, 05, 01),
             date(2016, 06, 01),
             date(2016, 07, 01)]
    for d in DATES:
        stat = TRazladkiStats('ok', d, 30)
        print '%s\tBNA kpi standart deviation = %3.3f' % (d, stat.get_kpi_deviation())
        print '%s\tBNA top standart deviation = %3.3f' % (d, stat.get_top_deviation())
        print '%s\tBNA stream standart deviation = %3.3f' % (d, stat.get_stream_deviation())
        print '%s\tsitelinks kpi standart deviation = %3.3f' % (d, stat.get_kpi_deviation_s())
        print '%s\tsitelinks top standart deviation = %3.3f' % (d, stat.get_top_deviation_s())
        print '%s\tsitelinks stream standart deviation = %3.3f' % (d, stat.get_stream_deviation_s())



if __name__ == '__main__':
    main()

