# -*- coding: utf-8 -*-


import os
import pandas as pd
import argparse
import json

import yt.wrapper as yt

from scipy.stats import mannwhitneyu as mw

class TextEnum:
    def __init__(self, **kwargs):
        self.name_to_value = dict(kwargs)
        self.value_to_name = dict((v, k) for (k,v) in self.name_to_value.items())

    def __getattr__(self, name):
        if name in self.name_to_value:
            return name
        raise AttributeError

########################################################################################################################

def p_value(cntrl_values, test_values):
    try:
        _,p_value = mw(cntrl_values,test_values)
        return p_value
    except:
        print "something went wrong"

########################################################################################################################

class Metric:
    def __init__(self, df, df2):
        self.df = df
        self.df2 = df2

    def ext(self):
        return '.wikimarkup'

    def make_cell(self, df, df2, ctrl, test_id, key):
        ctrl_metric = df2[df2["test_id"] == ctrl][key]
        metric = df2[df2["test_id"] == test_id][key]
        ctrl_values = df[df["test_id"] == ctrl].sort_values(by=["bucket"]).groupby(['bucket'])[key].sum()
        test_values = df[df["test_id"] == test_id].sort_values(by=["bucket"]).groupby(['bucket'])[key].sum()
        color = None
        try:
            metric = float(metric)
            ctrl_metric = float(ctrl_metric)
        except:
            metric = 0
            ctrl_metric = 0
        try:
            percent = (float(metric) / float(ctrl_metric) - 1) * 100
        except ZeroDivisionError:
            percent = 0
        if test_id == ctrl:
            text = '{value}\n'.format(
                value=float(metric))
        else:
            pvalue = p_value(ctrl_values, test_values)
            if not percent:
                pvalue = 0.99
            if "_time_" in key or "not_used" in key or "not_shown" in key:
                color = None if pvalue > 0.05 else 'red' if percent > 0 else 'green'
            else:
                color = None if pvalue > 0.05 else 'green' if percent > 0 else 'red'
            text = '{value}\n{percent:.2f}%\n{pvalue:.2f}\n'.format(
                value=float(metric),
                percent=percent,
                pvalue=pvalue)
        print text
        if color:
            text = '!!({color}){text}!!'.format(color=color, text=text)
        #print '%%(wacko wrapper=text align=right)\n{text}\n%%'.format( text=text)
        return '%%(wacko wrapper=text align=right)\n{text}\n%%'.format( text=text)


    def save(self, ctrl, f, test_ids):
        f.write('#|\n')
        f.write('||Metric|**{control}**|{test_ids}||\n'.format(
            control=ctrl, test_ids='|'.join([str(test_id) for test_id in test_ids])))
        print '||Metric|**{control}**|{test_ids}||\n'.format(
            control=ctrl, test_ids='|'.join([str(test_id) for test_id in test_ids]))
        for key in self.df:
            if key == "bucket" or key == "test_id" or type(key) == int:
                continue
            f.write('||{metric}|{control}|{test}||\n'.format(
                metric=key,
                control=self.make_cell(self.df, self.df2, ctrl, ctrl, key),
                test='|'.join([self.make_cell(self.df, self.df2, ctrl, test_id, key) for test_id in test_ids])))
        f.write('|#\n')


def get_yt_table(table_name):
    table = yt.read_table(table_name, 'dsv')
    df = pd.DataFrame(table)
    data = df.fillna('')
    data = data.apply(lambda x: pd.to_numeric(x, errors='ignore'))
    return data

########################################################################################################################

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-t', '--buckets_table', help='Input table by buckets')
    parser.add_argument('-t2', '--result_table', help='Input table with metrics')
    parser.add_argument('-ctid', '--ctrl_id', help='Ctrl id')
    parser.add_argument('-tids', '--test_ids', help='Test test_ids in format test_id1,test_id2')
    parser.add_argument('-fn','--file_name', help="Output file name", required=False, default='results')
    args = parser.parse_args()
    file_name = args.file_name
    ctrl= int(args.ctrl_id)
    test_ids = [int(test_id) for test_id in args.test_ids.split(',')]
    buckets_table = args.buckets_table
    results_table = args.result_table
    df = get_yt_table(table_name=buckets_table)
    df2 = get_yt_table(table_name=results_table)
    f = open(file_name, "w+")
    Rec = Metric(df, df2)

    f.write('<{Метрики саджеста по redir-log\n')
    Rec.save(ctrl=ctrl, f=f, test_ids=test_ids)
    f.write('}>')
    f.close()


if __name__ == "__main__":
    main()
