# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import sys


VOWELS = {"u":"a","o":"a","a":"a","ı":"a","ö":"e","ü":"e","e":"e","i":"e"}
DEAF_CONSONANT = "tpşsçfkh"


def is_vowel(char):
    return char in VOWELS


def is_deaf_consonant(char):
    return char in DEAF_CONSONANT


def add_affiks(word):
    last_char = word[-1]
    if is_vowel(last_char):
        suffix = '\'d%s' % VOWELS[last_char]
    else:
        rightmost_vowel = filter(is_vowel, word)[-1]
        if is_deaf_consonant(last_char):
            suffix = '\'t%s' % VOWELS[rightmost_vowel]
        else:
            suffix = '\'d%s' % VOWELS[rightmost_vowel]
    return word + suffix


if __name__ == '__main__':
    with open(sys.argv[1]) as f:
        for line in f:
            print add_affiks(line.strip().decode('utf8')).encode('utf8')

