import os
import sys
import urllib
from collections import deque


def dummy_parse(record, res):
    for field in record:
        if field:
            eq = field.find("=")
            if eq == -1:
                key = field
                val = None
            else:
                key = field[:eq]
                val = field[eq+1:]
            if res.has_key(key):
                if isinstance(res[key], list):
                    res[key].append(val)
                else:
                    res[key] = [res[key], val]
            else:
                res[key] = val
    return res

def ParseUSLine(record):
    res = {}
    record = record.rstrip("\n").split("\t")
    uid, ts, record = record[0], record[1], record[2:]
    res["yandexuid"] = uid
    res["ts"] = ts
    dummy_parse(record, res)
    return res



def CheckValue(record, valueName, reference):
    if valueName in record and record[valueName] == reference:
        return True
    return False

def experiment_namber(dict):
    exprt = dict["test-buckets"] if "test-buckets" in dict else ""
    found = False
    for a_exprt in exprt.split(";"):
        if a_exprt.startswith('12758,') or a_exprt.startswith("12757,"):
            dict["test-buckets"] = a_exprt.split(",")[0]
            found = True
            break
    return found

def Parse():
    UID_REFORMS = {}
    exp_stat = {"12757":[0,0], "12758": [0.0]}
    for line in sys.stdin:
        line = line.strip()
        record = ParseUSLine(line)
        if not experiment_namber(record):
                continue
        current_exp = record["test-buckets"]
        if (CheckValue(record, "type", "CLICK") and CheckValue(record, "service", "www.yandex")  and
            #CheckValue(record, "test-buckets", "12757") and
            (CheckValue(record, "ui", "www.yandex")  or CheckValue(record, "ui", "portal.yandex")) and
            (CheckValue(record, "path", "353.391") or CheckValue(record, "path", "1108.391")) and not CheckValue(record, "vars", "")):
            exp_stat[current_exp][0] += 1


        if (CheckValue(record, "type", "CLICK") and CheckValue(record, "service", "www.yandex") and
            #CheckValue(record, "test-buckets", "12757") and
            (CheckValue(record, "ui", "www.yandex")  or CheckValue(record, "ui", "portal.yandex")) and
            CheckValue(record, "source", "WEB") and "query" in record and UID_REFORMS and "url" in record):
            ref = record["referer"]  if "referer" in record else ""
            if "&rq=1" in record["referer"] if "referer" in record else "":
                exp_stat[current_exp][1] += 1

    for k,v in exp_stat.iteritems():
         print (k + "\t" + str(v))    
   

if __name__ == "__main__":
    Parse()











