import os
import sys
import urllib
import time
from datetime import datetime
from collections import deque


def dummy_parse(record, res):
    for field in record:
        if field:
            eq = field.find("=")
            if eq == -1:
                key = field
                val = None
            else:
                key = field[:eq]
                val = field[eq+1:]
            if res.has_key(key):
                if isinstance(res[key], list):
                    res[key].append(val)
                else:
                    res[key] = [res[key], val]
            else:
                res[key] = val
    return res

def ParseUSLine(record):
    res = {}
    record = record.rstrip("\n").split("\t")
    uid, ts, record = record[0], record[1], record[2:]
    res["yandexuid"] = uid
    res["ts"] = ts
    dummy_parse(record, res)
    return res



def CheckValue(record, valueName, reference):
    if valueName in record and record[valueName] == reference:
        return True
    return False

def Parse():
    UID_REFORMS = {}
    count = 0
    count_rq = 0
    for line in sys.stdin:
        line = line.strip()
        record = ParseUSLine(line)
        ts = datetime.fromtimestamp(int(record["ts"]))
        if ts.hour < 19:
            continue
        if (CheckValue(record, "type", "CLICK") and CheckValue(record, "service", "www.yandex")  and
            (CheckValue(record, "ui", "www.yandex")  or CheckValue(record, "ui", "portal.yandex")) and
            (CheckValue(record, "path", "353.391") or CheckValue(record, "path", "1108.391")) and not CheckValue(record, "vars", "")):
            count += 1


        if (CheckValue(record, "type", "CLICK") and CheckValue(record, "service", "www.yandex") and
            #CheckValue(record, "test-buckets", "12757") and
            (CheckValue(record, "ui", "www.yandex")  or CheckValue(record, "ui", "portal.yandex")) and
            CheckValue(record, "source", "WEB") and "query" in record and "url" in record):
            ref = record["referer"]  if "referer" in record else ""
            if record["referer"].find("&rq=1") != -1:
                count_rq += 1

    print str(count) + "\t" + str(count_rq) + "\t"  
   

if __name__ == "__main__":
    Parse()












