#!/usr/bin/env python2.7

# you should get blockstat.dict and place it nearby
# also you need mapreducelib.py and libra.so

import sys
import libra
from mapreducelib import MapReduce, Record




def extract_clicks(key, recs):
    try:
        for item in libra.ParseSession(recs, "blockstat.dict"):
            if not item.IsA("TYandexWebRequest"):
                continue
            sugg =  item.GetSuggest()
            if not sugg:
                continue
            if not sugg.HasTestID("12699"):
                continue
            corr = ""
            if item.IsMSP:
                corr = item.GetMSP().CorrectedQuery
            if item.IsReask:
                corr = item.GetReask().CorrectedQuery
            yield Record(
                item.Query,
                corr,
                str(item.UserRegion))
    except:
        pass


if __name__ == "__main__":
    try:
        src_table, dst_table = sys.argv[1:]
    except:
        print "Usage: %s <src_table> <dst_table>" % sys.argv[0]
        sys.exit(1)

    MapReduce.useDefaults(verbose=True, mrExec="mapreduce", server="cedar00.search.yandex.net:8013", username="suggest")
    MapReduce.runReduce(extract_clicks, srcTable=src_table, dstTable=dst_table, files=["blockstat.dict"])
