import sys
import libra
from mapreducelib import MapReduce, Record




def extract_clicks(key, recs):
    try:
        for item in libra.ParseSession(recs, "blockstat.dict"):
            if not item.IsA("TYandexWebRequest"):
                continue
            sugg =  item.GetSuggest()
            if not sugg:
                continue
            if not sugg.HasTestID("14034"):
                continue
            if not item.HasTestID("14009"):
                continue
            yield Record(
                item.UID,
                "",
                "")
    except:
        pass


if __name__ == "__main__":
    try:
        src_table, dst_table = sys.argv[1:]
    except:
        print "Usage: %s <src_table> <dst_table>" % sys.argv[0]
        sys.exit(1)

    MapReduce.useDefaults(verbose=True, mrExec="mapreduce", server="cedar00.search.yandex.net:8013", username="suggest")
    MapReduce.runReduce(extract_clicks, srcTable=src_table, dstTable=dst_table, files=["blockstat.dict"])
