#!/usr/bin/env python2.7

# you should get blockstat.dict and place it nearby
# also you need mapreducelib.py and libra.so

import sys
import libra
from mapreducelib import MapReduce, Record




def extract_clicks(key, recs):
    try:
        for item in libra.ParseSession(recs, "blockstat.dict"):
            if not item.IsA("TYandexImagesRequest"):
                continue
            if not item.HasTestID("12908"):
                continue
            fullreq = item.FullRequest
            if fullreq.find("&suggest-portal-from=serp") != -1:        
                click = len(item.GetClicks())
                yield Record(
                    item.Query, str(click), "")
    except:
        print >> sys.stderr, sys.exc_info()
        pass


if __name__ == "__main__":
    try:
        src_table, dst_table = sys.argv[1:]
    except:
        print "Usage: %s <src_table> <dst_table>" % sys.argv[0]
        sys.exit(1)

    MapReduce.useDefaults(verbose=True, mrExec="mapreduce", server="cedar00.search.yandex.net:8013", username="suggest")
    MapReduce.runReduce(extract_clicks, srcTable=src_table, dstTable=dst_table, files=["blockstat.dict"])

