import yt.wrapper
import sys
import urlparse
import re
import urllib
import urllib2
import math
import json
import time
import datetime
from datetime import date, datetime, timedelta
import argparse
import ast
# import libra

def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--timestamp', help='date timestamp for calculation')
    parser.add_argument('--from_date', default='2017-02-28',  help='from date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--to_date', default='2017-02-28', help='to date for calculation (format: YYYY-MM-DD)')
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict", default='/home/galamaj/blockstat.dict', required=False)
    # parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    # parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    args = parser.parse_args()
    return args

def get_dates(timestamp, from_date, to_date):
    dates = []
    date_format = '%Y-%m-%d'
    if timestamp:
        date = datetime.fromtimestamp(int(timestamp[:10]))
        dates.append(date.strftime(date_format))
    if from_date and not to_date:
        to_date = datetime.strftime(datetime.now(), date_format)
    if from_date and to_date:
        current_date = datetime.strptime(from_date, date_format)
        while current_date <= datetime.strptime(to_date, date_format):
            dates.append(current_date.strftime(date_format))
            current_date += timedelta(1)
    return dates

# def mapper(row):
#     if row["exprt"] == "41632":
#         yield row

def group_by_browser(key, recs):
    datas = 0
    errors = 0
    continues = 0
    helps = 0
    inits = 0
    pcontinues = 0
    pstops = 0
    starts = 0
    stops = 0
    for rec in recs:
        bro = rec["browser"]
        exprt = rec["exprt"]
        datas += rec["data"]
        errors += rec["error"]
        continues += rec["continue"]
        helps += rec["help"]
        inits += rec["init"]
        pcontinues += rec["paranja_continue"]
        pstops += rec["paranja_stop"]
        starts += rec["start"]
        stops += rec["stop"]
    try:
        yield {
            "exprt" : exprt,
            "browser" : bro,
            "start" : starts,
            "init" : inits,
            "stop" : stops,
            "data" : datas,
            "error" : errors,
            "continue" : continues,
            "paranja_stop" : pstops,
            "paranja_continue" : pcontinues,
            "help" : helps,
            "conversion" : datas/float(starts)*100
        }
    except ZeroDivisionError:
        yield {
            "exprt" : exprt,
            "browser" : bro,
            "start" : starts,
            "init" : inits,
            "stop" : stops,
            "data" : datas,
            "error" : errors,
            "continue" : continues,
            "paranja_stop" : pstops,
            "paranja_continue" : pcontinues,
            "help" : helps,
            "conversion" : None
        }



# def group_by_browser_version(key, recs):



def calculations(date):
    inputTable = '//home/suggest-dev/galamaj/analytics/web_voice/only_exprt_check_' + date
    outputTable = '//home/suggest-dev/galamaj/analytics/web_voice/conversion/check_' + date
    yt.wrapper.create("table", path = outputTable, recursive = True, ignore_existing = True, attributes = None)
    outputPath = yt.wrapper.TablePath(outputTable)
    print "%s   %s -> %s" % (str(datetime.now()), inputTable, outputTable)
    yt.wrapper.run_sort(inputTable,sort_by=['exprt', 'browser'])
    # yt.wrapper.run_map_reduce(mapper, group_by_browser, inputTable, outputPath, reduce_by=['exprt', 'browser'])
    yt.wrapper.run_reduce(group_by_browser, inputTable, outputPath, reduce_by=['exprt', 'browser'])


if __name__ == '__main__':
    args = parse_args()
    dates = get_dates(args.timestamp, args.from_date, args.to_date)
    print dates
    for date in dates:
        calculations(date)
