import yt.wrapper as yt
import sys
import argparse

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest="server", help="yt server",default='hahn.yt.yandex.net', required=False)
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict",default='/home/galamaj/blockstat.dict', required=False)
    return parser


def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--timestamp', help='date timestamp for calculation')
    parser.add_argument('--from_date', default='2017-02-28',  help='from date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--to_date', default='2017-02-28', help='to date for calculation (format: YYYY-MM-DD)')
    parser.add_argument("--bs", dest="blockstat", help="path to blockstat.dict", default='/home/galamaj/blockstat.dict', required=False)
    # parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    # parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    args = parser.parse_args()
    return args

def get_dates(timestamp, from_date, to_date):
    dates = []
    date_format = '%Y-%m-%d'
    if timestamp:
        date = datetime.fromtimestamp(int(timestamp[:10]))
        dates.append(date.strftime(date_format))
    if from_date and not to_date:
        to_date = datetime.strftime(datetime.now(), date_format)
    if from_date and to_date:
        current_date = datetime.strptime(from_date, date_format)
        while current_date <= datetime.strptime(to_date, date_format):
            dates.append(current_date.strftime(date_format))
            current_date += timedelta(1)
    return dates

def mapper(row):
    if row["testid"] == "41128" and row["path"].find("suggest_example.voice.") != -1 and row["device"] == "touch":
        yield row


def reduce_by_browser(key, recs):
    show_item = 0
    click_item = 0
    show_close = 0
    show_done = 0
    click_close = 0
    click_done = 0
    contextmenu_close = 0
    MediaDeviceFailedDueToShutdown = 0
    PermissionDeniedError = 0
    PermissionDismissedError = 0
    backendError = 0
    Onlysecureoriginsareallowed = 0
    initFail400 = 0
    requestTimeout = 0
    show_denied = 0
    click_denied = 0
    show_fail = 0
    click_fail = 0
    show_repeat = 0
    click_repeat = 0
    success = 0
    undefined = 0
    for rec in recs:
        bro = rec["browser"]
        if rec["event_type"] == "show":
            if rec["path"].find("voice.item") != -1:
                show_item += 1
            if rec["path"].find("voice.speak.close") != -1:
                show_close += 1
            if rec["path"].find("voice.speak.done") != -1:
                show_done += 1
            if rec["path"].find("voice.speak.error.denied") != -1:
                show_denied += 1
            if rec["path"].find("voice.speak.error.fail") != -1:
                show_fail += 1
            if rec["path"].find("voice.speak.repeat") != -1:
                show_repeat += 1
        if rec["event_type"] == "click":
            if rec["path"].find("voice.item") != -1:
                click_item += 1
            if rec["path"].find("voice.speak.close") != -1:
                click_close += 1
            if rec["path"].find("voice.speak.done") != -1:
                click_done += 1
            if rec["path"].find("voice.speak.error.denied") != -1:
                click_denied += 1
            if rec["path"].find("voice.speak.error.fail") != -1:
                click_fail += 1
            if rec["path"].find("voice.speak.repeat") != -1:
                click_repeat += 1
        if rec["event_type"] == "contextmenu":
            if rec["path"].find("voice.speak.close") != -1:
                contextmenu_close += 1
        if rec["event_type"] == "tech":
            if rec["path"].find("speak.err_type.MediaDeviceFailedDueToShutdown") != -1:
                MediaDeviceFailedDueToShutdown += 1
            if rec["path"].find("speak.err_type.PermissionDeniedError") != -1:
                PermissionDeniedError += 1
            if rec["path"].find("speak.err_type.PermissionDismissedError") != -1:
                PermissionDismissedError += 1
            if rec["path"].find("speak.err_type.backendError") != -1:
                backendError += 1
            if rec["path"].find("speak.err_type.generic_error.Only") != -1:
                Onlysecureoriginsareallowed += 1
            if rec["path"].find("speak.err_type.initFail.400") != -1:
                initFail400 += 1
            if rec["path"].find("speak.err_type.requestTimeout") != -1:
                requestTimeout += 1
            if rec["path"].find("voice.speak.success") != -1:
                success += 1
        else:
            undefined += 1
    yield {
        "browser" : bro,
        "show_item" : show_item,
        "click_item" : click_item,
        "show_done" : show_done,
        "click_done" : click_done,
        "success" : success,
        "show_repeat" : show_repeat,
        "click_repeat" : click_repeat,
        "show_denied" : show_denied,
        "click_denied" : click_denied,
        "show_fail" : show_fail,
        "click_fail" : click_fail,
        "show_close" : show_close,
        "click_close" : click_close,
        "error_MediaDeviceFailedDueToShutdown" : MediaDeviceFailedDueToShutdown,
        "error_PermissionDeniedError" : PermissionDeniedError,
        "error_PermissionDismissedError" : PermissionDismissedError,
        "error_BackendError" : backendError,
        "Only_secure_origins_are_allowed" : Onlysecureoriginsareallowed,
        "initFail_400" : initFail400,
        "RequestTimeout" : requestTimeout,
        "undefined_action" : undefined,
        "contextmenu_close" : contextmenu_close
    }









def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})
    days = ["2017-03-28", "2017-03-29", "2017-03-30", "2017-03-31", "2017-04-01", "2017-04-02", "2017-04-03", "2017-04-04", "2017-04-05", "2017-04-06", "2017-04-07", "2017-04-08", "2017-04-09", "2017-04-10"]#'2016-12-09', '2016-12-10', '2016-12-11', '2016-12-12', '2016-12-13', '2016-12-14', '2016-12-15', '2016-12-27', '2016-12-28', '2016-12-29', '2016-12-30', '2016-12-31', '2017-01-01', '2017-01-02', '2017-01-03', '2017-01-04', '2017-01-05', '2017-01-06', '2017-01-07', '2017-01-08', '2017-02-10','2017-02-11', '2017-02-12', '2017-02-13','2017-02-14', '2017-02-15',
    uids = {}

    for day in days:
        input = '//home/search-research/kaminsky/EXPERIMENTS/RESULT/' + day + '/total_exp_events'
        output = '//home/suggest-dev/galamaj/analytics/web_voice/morda_exprt/' + day
        if not yt.exists(output):
            yt.create_table(path=output, recursive=True)
        yt.run_map_reduce(mapper, reduce_by_browser, input, output, reduce_by = 'browser', spec = {'data_size_per_job': 16000000000}) #~16GB

if __name__ == '__main__':
    main()
