# coding=utf-8

import requests
import json
import yt.wrapper as yt
import sys
import time
import datetime
from datetime import date, datetime, timedelta
import argparse


IP_TO_COUNTRY_NAME_MAP = {
    225: "Ru",
    187: "Ua",
    149: "By",
    159: "Kz",
    983: "Tr",
    171: "Uz",
    170: "Tm",
    209: "Tj",
    168: "Am",
    167: "Az",
    169: "Ge",
    207: "Kg",
    208: "Md"
}


def get_country_name(ip):
    return IP_TO_COUNTRY_NAME_MAP.get(ip)

def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--timestamp', help='date timestamp for calculation')
    parser.add_argument('--from_date', default='2017-07-17', help='from date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--to_date', default='2017-07-17', help='to date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    args = parser.parse_args()
    return args

def get_dates(timestamp, from_date, to_date):
    dates = []
    date_format = '%Y-%m-%d'
    if timestamp:
        date = datetime.fromtimestamp(int(timestamp[:10]))
        dates.append(date.strftime(date_format))
    if from_date and not to_date:
        to_date = datetime.strftime(datetime.now(), date_format)
    if from_date and to_date:
        current_date = datetime.strptime(from_date, date_format)
        while current_date <= datetime.strptime(to_date, date_format):
            dates.append(current_date.strftime(date_format))
            current_date += timedelta(1)
    return dates

def read_total(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    platform = None
    for row in yt.read_table(inputTable):
        d = {}
        # version = row['ver']
        d['fielddate'] = date
        d['version'] = "\tversion\t"
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_ver(date, inputTable):
    # inputTable = '//home/suggest-dev/galamaj/tmp/yastroka_dau/ver_' + date
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    platform = None
    for row in yt.read_table(inputTable):
        d = {}
        version = row['ver']
        if version is None:
            version = "undefined"
        d['fielddate'] = date
        d['version'] = "\tversion\tversion\t" + version + "\t"
        if row['total'] < 500:
            continue
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_dayuse(date, inputTable):
    # inputTable = '//home/suggest-dev/galamaj/tmp/yastroka_dau/ver_' + date
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        dayuse = row['dayuse']
        if dayuse is None:
            dayuse = "undefined"
        d['fielddate'] = date
        d['version'] = "\tversion\tdayuse\t" + dayuse + "\t"
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data


def read_distr(date, inputTable):
    # inputTable = '//home/suggest-dev/galamaj/tmp/yastroka_dau/ver_' + date
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        distr_type = row['distr_type']
        if distr_type is None:
            distr_type = "undefined"
        d['fielddate'] = date
        d['version'] = "\tversion\tdistribution\t" + distr_type + "\t"
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_strview(date, inputTable):
    # inputTable = '//home/suggest-dev/galamaj/tmp/yastroka_dau/ver_' + date
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        str_view = row['str_view']
        if str_view is None:
            str_view = "undefined"
        d['fielddate'] = date
        d['version'] = "\tversion\tstr_view\t" + str_view + "\t"
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def post_to_stat(data, scale='d', beta = True, _append_mode=1):
    '''data is dict of values :
    data = [
                {'fielddate': '2015-02-03', 'project': 'Portal', 'name': '400', 'field1': 99},
                {'fielddate': '2015-02-03', 'project': 'Morda', 'name': '400', 'field1': 30},
                {'fielddate': '2015-02-04', 'project': 'Portal', 'name': '400', 'field1': 19},
                {'fielddate': '2015-02-04', 'project': 'Morda', 'name': '400', 'field1': 102},
            ]
    '''
    name = 'Market/Others/yastoka'
    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers = {
            'Authorization' : 'OAuth AQAD-qJSJjnvAAAIDexOvNG_VEKYtY-v7AP7w1A'
        },
        data={
            'name': name,
            'scale': scale,
            'json_data': json.dumps({'values': data}),
            '_append_mode':_append_mode
        },
    )
    return r.text

if __name__ == '__main__':
    args = parse_args()
    dates = get_dates(args.timestamp, args.from_date, args.to_date)
    print dates
    for date in dates:
        data = []
        ver_dau = '//home/suggest-dev/galamaj/tmp/yastroka_dau/ver_' + date
        dayuse_dau = '//home/suggest-dev/galamaj/tmp/yastroka_dau/dayuse_' + date
        distr_dau = '//home/suggest-dev/galamaj/tmp/yastroka_dau/distr_' + date
        strview_dau = '//home/suggest-dev/galamaj/tmp/yastroka_dau/strview_' + date
        total_dau = '//home/suggest-dev/galamaj/tmp/yastroka_dau/total_' + date
        data += read_total(date, total_dau)
        data += read_dayuse(date, dayuse_dau)
        data += read_distr(date, distr_dau)
        data += read_strview(date, strview_dau)
        data += read_ver(date, ver_dau)
        push_to_stat = post_to_stat(data)
        print push_to_stat
