# coding=utf-8

import requests
import json
import yt.wrapper as yt
import sys
import time
import datetime
from datetime import date, datetime, timedelta
import argparse


IP_TO_COUNTRY_NAME_MAP = {
    225: "Ru",
    187: "Ua",
    149: "By",
    159: "Kz",
    983: "Tr",
    171: "Uz",
    170: "Tm",
    209: "Tj",
    168: "Am",
    167: "Az",
    169: "Ge",
    207: "Kg",
    208: "Md"
}


def get_country_name(ip):
    return IP_TO_COUNTRY_NAME_MAP.get(ip)

def parse_args():
    parser = argparse.ArgumentParser(add_help=True, description='Suggest metrics calc')
    parser.add_argument('--timestamp', help='date timestamp for calculation')
    parser.add_argument('--from_date', help='from date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--to_date', help='to date for calculation (format: YYYY-MM-DD)')
    parser.add_argument('--mr_server', default='hahn', help='MR server (hahn, banach, ...)')
    parser.add_argument('--yt_pool', default='robot-suggestor-dev', help='YT pool')
    parser.add_argument('--stat_user', help="token for Statistics")
    args = parser.parse_args()
    return args

def get_dates(timestamp, from_date, to_date):
    dates = []
    date_format = '%Y-%m-%d'
    if timestamp:
        date = datetime.fromtimestamp(int(timestamp[:10]))
        dates.append(date.strftime(date_format))
    if from_date and not to_date:
        to_date = datetime.strftime(datetime.now(), date_format)
    if from_date and to_date:
        current_date = datetime.strptime(from_date, date_format)
        while current_date <= datetime.strptime(to_date, date_format):
            dates.append(current_date.strftime(date_format))
            current_date += timedelta(1)
    return dates

def read_total(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        d['fielddate'] = date
        d['dau'] = "\tdau\t"
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_ver(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        version = row['ver']
        if version is None:
            version = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tversion\t" + version + "\t"
        if row['total'] < 1000:
            continue
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_dayuse(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        dayuse = row['dayuse']
        if dayuse is None:
            dayuse = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tdayuse\t" + dayuse + "\t"
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data


def read_distr(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        distr_type = row['distr_type']
        if distr_type is None:
            distr_type = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tdistribution\t" + distr_type + "\t"
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_strview(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        str_view = row['str_view']
        if str_view is None:
            str_view = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tstr_view\t" + str_view + "\t"
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_strview_dayuse(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        str_view = row['str_view']
        dayuse = row['dayuse']
        if str_view is None:
            str_view = "undefined"
        if dayuse is None:
            dayuse = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tstr_view\t" + str_view + "\tdayuse\t" + dayuse + "\t"
        for key in row.keys():
            if key == 'str_view' or key == 'dayuse':
                continue
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_strview_distr(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        str_view = row['str_view']
        distr = row['distr_type']
        if str_view is None:
            str_view = "undefined"
        if distr is None:
            distr = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tstr_view\t" + str_view + "\tdistribution\t" + distr + "\t"
        for key in row.keys():
            if key == 'str_view' or key == 'distr_type':
                continue
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_strview_distr_dayuse(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        str_view = row['str_view']
        distr = row['distr_type']
        dayuse = row['dayuse']
        if str_view is None:
            str_view = "undefined"
        if distr is None:
            distr = "undefined"
        if dayuse is None:
            dayuse = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tstr_view\t" + str_view + "\tdistribution\t" + distr + "\tdayuse\t" + dayuse + "\t"
        for key in row.keys():
            if key == 'str_view' or key == 'dayuse' or key == 'distr_type':
                continue
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_distr_dayuse(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        distr = row['distr_type']
        dayuse = row['dayuse']
        if distr is None:
            distr = "undefined"
        if dayuse is None:
            dayuse = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tdistribution\t" + distr + "\tdayuse\t" + dayuse + "\t"
        for key in row.keys():
            if key == 'distr_type' or key == 'dayuse':
                continue
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_mic(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        mic = row['mic']
        if mic is None:
            mic = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tmicrophone_status\t" + mic + "\t"
        for key in row.keys():
            if key == 'mic':
                continue
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_mic_ver(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        mic = row['mic']
        version = row['ver']
        if version is None:
            version = "undefined"
        if mic is None:
            mic = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tmicrophone_status\t" + mic + "\tversion\t" + version + "\t"
        if row['total'] < 500:
            continue
        for key in row.keys():
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_mic_strview(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        mic = row['mic']
        strview = row['str_view']
        if mic is None:
            mic = "undefined"
        if strview is None:
            strview = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tmicrophone_status\t" + mic + "\tstr_view\t" + strview + "\t"
        for key in row.keys():
            if key == 'mic' or key == 'str_view':
                continue
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_mic_distr(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        mic = row['mic']
        distr = row['distr_type']
        if mic is None:
            mic = "undefined"
        if distr is None:
            distr = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tmicrophone_status\t" + mic + "\tdistr_type\t" + distr + "\t"
        for key in row.keys():
            if key == 'mic' or key == 'distr_type':
                continue
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data

def read_mic_dayuse(date, inputTable):
    yt.config['memory_limit'] = 100 * 1024 * 1024 * 1024
    print "%s ->  %s" % (str(datetime.now()), inputTable)
    data = []
    for row in yt.read_table(inputTable):
        d = {}
        mic = row['mic']
        distr = row['dayuse']
        if mic is None:
            mic = "undefined"
        if distr is None:
            distr = "undefined"
        d['fielddate'] = date
        d['dau'] = "\tdau\tmicrophone_status\t" + mic + "\tdayuse\t" + distr + "\t"
        for key in row.keys():
            if key == 'mic' or key == 'dayuse':
                continue
            d[key] = str(row[key])
        for key in d.keys():
            if d[key] == "None":
                del d[key]
        data.append(d)
    return data


def post_to_stat(data, token, scale='d', beta = True, _append_mode=1):
    '''data is dict of values :
    data = [
                {'fielddate': '2015-02-03', 'project': 'Portal', 'name': '400', 'field1': 99},
                {'fielddate': '2015-02-03', 'project': 'Morda', 'name': '400', 'field1': 30},
                {'fielddate': '2015-02-04', 'project': 'Portal', 'name': '400', 'field1': 19},
                {'fielddate': '2015-02-04', 'project': 'Morda', 'name': '400', 'field1': 102},
            ]
    '''
    name = 'Soft/YaStroka/DAU_by_day'
    r = requests.post(
        'https://upload.stat.yandex-team.ru/_api/report/data',
        headers = {
            'Authorization' : 'OAuth ' + token
        },
        data={
            'name': name,
            'scale': scale,
            'json_data': json.dumps({'values': data}),
            '_append_mode':_append_mode
        },
    )
    return r.text

if __name__ == '__main__':
    args = parse_args()
    dates = get_dates(args.timestamp, args.from_date, args.to_date)
    if dates == []:
        for line in sys.stdin:
            print line
            dates.append(line.rstrip("\n"))
    print dates
    for date in dates:
        try:
            data = []
            ver_dau = '//home/suggest-dev/galamaj/yastroka/dau/ver/' + date
            dayuse_dau = '//home/suggest-dev/galamaj/yastroka/dau/dayuse/' + date
            distr_dau = '//home/suggest-dev/galamaj/yastroka/dau/distr/' + date
            strview_dau = '//home/suggest-dev/galamaj/yastroka/dau/strview/' + date
            total_dau = '//home/suggest-dev/galamaj/yastroka/dau/total/' + date
            strview_dayuse_dau = '//home/suggest-dev/galamaj/yastroka/dau/strview_dayuse/' + date
            strview_distr_dau = '//home/suggest-dev/galamaj/yastroka/dau/strview_distr/' + date
            distr_dayuse_dau = '//home/suggest-dev/galamaj/yastroka/dau/distr_dayuse/' + date
            strview_distr_dayuse_dau = '//home/suggest-dev/galamaj/yastroka/dau/strview_distr_dayuse/' + date
            mic_dau = '//home/suggest-dev/galamaj/yastroka/dau/mic/' + date
            mic_ver_dau = '//home/suggest-dev/galamaj/yastroka/dau/mic_ver/' + date
            mic_dayuse_dau = '//home/suggest-dev/galamaj/yastroka/dau/mic_dayuse/' + date
            mic_strview_dau = '//home/suggest-dev/galamaj/yastroka/dau/mic_strview/' + date
            mic_distr_dau = '//home/suggest-dev/galamaj/yastroka/dau/mic_distr/' + date
            data += read_total(date, total_dau)
            data += read_dayuse(date, dayuse_dau)
            data += read_distr(date, distr_dau)
            data += read_strview(date, strview_dau)
            data += read_ver(date, ver_dau)
            data += read_strview_dayuse(date, strview_dayuse_dau)
            data += read_strview_distr(date, strview_distr_dau)
            data += read_strview_distr_dayuse(date, strview_distr_dayuse_dau)
            data += read_distr_dayuse(date, distr_dayuse_dau)
            data += read_mic(date, mic_dau)
            data += read_mic_ver(date, mic_ver_dau)
            data += read_mic_dayuse(date, mic_dayuse_dau)
            data += read_mic_distr(date, mic_distr_dau)
            data += read_mic_strview(date, mic_strview_dau)
            print data
            push_to_stat = post_to_stat(data, args.stat_token)
            print push_to_stat
        except:
            continue
