#!/usr/bin/env python

from datetime import datetime, timedelta
from yql.api.v1.client import YqlClient


yql_script = '''
PRAGMA yt.Pool = 'robot-suggestor';
PRAGMA inferscheme;

USE hahn;

$functions = FileContent("functions.py");

$EncodeValue = Python::EncodeValue("(String?)->String?", $functions);
$GetLr = Python::GetLr("(String?)->Int32?", $functions);
$TableDate = Python::TableDate($functions);

$redir_dict = (
SELECT Dsv::Parse(redir.value) as d
FROM [logs/redir-log/1d/@@TODAY] as redir
where value LIKE '%cid=2873%'
LIMIT 10);

INSERT INTO [home/search-functionality/suggest_logs/redir_log_parsed/@@TODAY] WITH TRUNCATE

SELECT
    sd.d{'HTTP_REFERER'} as referer,
    sd.d{'path'} as path,
    $GetLr(sd.d{'HTTP_REFERER'}) as lr,
    $EncodeValue(sd.d{'text'}) as text,
    $EncodeValue(sd.d{'user_input'}) as user_input,
    $EncodeValue(sd.d{'prev_query'}) as prev_query,
    CAST(sd.d{'since_first_change'} as Int64) as since_first_change,
    CAST(sd.d{'since_last_change'} as Int64) as since_last_change,
    sd.d{'ratio'} as ratio,
    sd.d{'log'} as log,
    sd.d{'session'} as session,
    sd.d{'suggest_reqid'} as suggest_reqid,
    sd.d{'pos'} as pos,
    sd.d{'tpah_log'} as tpah_log,
    sd.d{'times'} as times,
    sd.d{'render_times'} as render_times,
    sd.d{'ip'} as ip,
    sd.d{'timestamp'} as timestamp,
    sd.d{'yandexuid'} as yandexuid,
    sd.d{'region'} as region,
    sd.d{'url'} as url,
    sd.d{'iso_eventtime'} as iso_eventtime
FROM $redir_dict AS sd;
'''


def TableDate():
    date_now = datetime.now().date()
    date = str(date_now - timedelta(days=1))
    return date


def main():
    # OAuth token can be passed via YqlClient() argument or YQL_TOKEN env variable
    # Open https://yql.yandex-team.ru/?settings_mode=token in browser to get your token
    client = YqlClient()
    import logging
    logging.basicConfig(level=logging.DEBUG)
    try:
        request = client.query(yql_script.replace("@@TODAY", TableDate()))
    except Exception as e:
        print e
        raise
    request.attach_file('functions.py')
    request.run()
    print request

if __name__ == '__main__':
    main()
