#!/usr/bin/env python

import re
import os
import urlparse
from datetime import date, datetime, timedelta
from yql.api.v1.client import YqlClient


yql_script = '''
PRAGMA yt.Pool = 'robot-suggestor';
PRAGMA inferscheme;

USE hahn;

$functions = FileContent("functions.py");

$EncodeValue = Python::EncodeValue("(String?)->String?", $functions);
$GetLr = Python::GetLr("(String?)->Int32?", $functions);
$TableDate = Python::TableDate($functions);

INSERT INTO [home/search-functionality/suggest_logs/redir_log_parsed/@@TODAY] WITH TRUNCATE

SELECT
    redir.dict{'HTTP_REFERER'} as referer,
    redir.dict{'path'} as path,
    $GetLr(redir.dict{'HTTP_REFERER'}) as lr,
    $EncodeValue(redir.dict{'text'}) as text,
    $EncodeValue(redir.dict{'user_input'}) as user_input,
    $EncodeValue(redir.dict{'prev_query'}) as prev_query,
    CAST(redir.dict{'since_first_change'} as Int64) as since_first_change,
    CAST(redir.dict{'since_last_change'} as Int64) as since_last_change,
    redir.dict{'ratio'} as ratio,
    redir.dict{'log'} as log,
    redir.dict{'session'} as session,
    redir.dict{'suggest_reqid'} as suggest_reqid,
    redir.dict{'pos'} as pos,
    redir.dict{'tpah_log'} as tpah_log,
    redir.dict{'times'} as times,
    redir.dict{'render_times'} as render_times,
    redir.dict{'ip'} as ip,
    redir.dict{'timestamp'} as timestamp,
    redir.dict{'yandexuid'} as yandexuid,
    redir.dict{'region'} as region,
    redir.dict{'url'} as url,
    redir.dict{'iso_eventtime'} as iso_eventtime,
    Geo::FindCountry(Geo::RegionByIp(redir.dict{"ip"}).id) as country,
    Geo::RegionByIp(redir.dict{"ip"}).id as region_by_ip
FROM [logs/redir-log/1d/@@TODAY] as redir
where redir.dict{'cid'} = '2873';
'''

def TableDate():
    date_now = datetime.now().date()
    date = str(date_now - timedelta(days=1))
    return date


def main():
    # OAuth token can be passed via YqlClient() argument or YQL_TOKEN env variable
    # Open https://yql.yandex-team.ru/?settings_mode=token in browser to get your token
    client = YqlClient()
    try:
        request = client.query(yql_script.replace("@@TODAY", TableDate()))
    except Exception as e:
        print e
        raise
    request.attach_file('functions.py')
    request.run()
    print request

#if __name__ == '__main__':
main()
