TEMPLATES = dict(
    task_root='//home/geoadv/ikolodkin/GEOANALYTICS-681-adv-retention',
    tmp_files='$task_root/tmp/tmp_files',
    rubric_requests='$task_root/geocube/rubric_requests',
    companies='$task_root/companies/all',
    metrics='$job_root/geocube/metrics',
    checkpoints_root='$task_root/checkpoints',
    geocube='//home/geosearch-prod/geocube/1d',
    company_to_chain='//home/sprav/altay/prod/snapshot/company_to_chain'
)



def _check_condition(record, condition):
    for key, value in condition.iteritems():
        if callable(value):
            yield value(record.get(key, None))
        elif isinstance(value, list):
            yield record.get(key, None) in value
        else:
            yield record.get(key, None) == value


def detect_by_record(conditions):
    def result_function(record):
        for condition in conditions:
            if all(_check_condition(record, condition)):
                return True
        return False

    return result_function


class SingleEventHook(object):
    """
    Hook that triggers on a single (but not unique) event.
    For instance, if class is initialized with hooks
        [
            {'x': 'y'},
            {'x': 'z'}
        ]
    than SingleEventHook will trigger on each event that has field 'x' equal to 'y' or 'z'
    """

    def __init__(self, hooks):
        self.hooks = hooks

    def __call__(self, event):
        if detect_by_record(self.hooks)(event):
            return True

        return False


