import math


def points_distance(lat1, lon1, lat2, lon2):
    """Distance between GeoPoints (in metres)"""
    radius = 6371 * 1000
    dlat = math.radians(lat2 - lat1)
    dlon = math.radians(lon2 - lon1)
    a = math.sin(dlat / 2) * math.sin(dlat / 2) + math.cos(math.radians(lat1)) * math.cos(
        math.radians(lat2)) * math.sin(dlon / 2) * math.sin(dlon / 2)
    c = 2 * math.atan2(math.sqrt(a), math.sqrt(1 - a))
    d = radius * c

    return d


def get_bounds_distance(ll, spn):
    lon, lat = map(float, ll.split(','))
    lon_diff, lat_diff = map(float, spn.split(','))
    lat1, lon1, lat2, lon2 = lat - lat_diff / 2, lon - lon_diff / 2, lat + lat_diff / 2, lon + lon_diff / 2
    distance = points_distance(lat1, lon1, lat2, lon2)
    return distance
