from common import SingleEventHook

MAPS_DEEP_USE = SingleEventHook([
    {'path': lambda _: _ and
                       _.startswith('maps_www.serp_panel.preview_card.') and
                       _ != 'maps_www.serp_panel.preview_card.back',
     },
    {'path': [
        'maps_www.routes_control',
        'maps_www.print',
        'maps_www.share_popup.share_view.code.copy',
        'maps_www.share_popup.share_view.code',
        'maps_www.share_popup.share_view.link.copy',
        'maps_www.share_popup.share_view.link',
        'maps_www.share_popup.share_view.social'
    ],
    },
])

MAPS_GOOD_USE = SingleEventHook([
    {'path': [
        'maps_www.serp_panel.results.result_item',
        'maps_www.map.search_results.placemark',
        # 'maps_www.map.search_results.cloud'
    ],
    },
])

MAPS_GOOD_USE_MAP = SingleEventHook([
    {'path': [
        'maps_www.map.search_results.placemark',
        # 'maps_www.map.search_results.cloud'
    ],
    },
])

MAPS_GOOD_USE_SERP = SingleEventHook([
    {'path': [
        'maps_www.serp_panel.results.result_item'
    ],
    },
])

MAPS_MAKE_ROUTE = SingleEventHook([
    {'path': [
        'maps_www.serp_panel.preview_card.route_button',
        'maps_www.routes_control',
        'maps_www.serp_panel.preview_card.metro.metro_route',
        'maps_www.serp_panel.preview_card.metro.content.metro_route',
        'maps_www.orgpage.content.header.route_action'
    ],
    },
])

MAPS_SITE = SingleEventHook([
    {'path': [
        'maps_www.serp_panel.preview_card.urls.url',
        'maps_www.orgpage.content.url',
        'maps_www.serp_panel.preview_card.offer.content.url',
        'maps_www.serp_panel.preview_card.urls.content.url',
        'maps_www.serp_panel.preview_card.popular.carousel.url'
    ],
    },
])

MOBILE_MAPS_DEEP_USE = SingleEventHook([
    {'path': lambda _: _ and
                       _.startswith('place.') and
                       _ not in ['place.ugc-panel.appear', 'place.ugc-panel.hide'],
     },
    {'path': [
        "add-review.submit",
        "add-review.attempt",
        "add-bookmark.attempt",
        "add-bookmark.submit"
    ],
    },
])

MOBILE_MAPS_GOOD_USE = SingleEventHook([
    {'path': [
        'search.open-place-view',
        'search.show-place-card'
    ],
    },
])

MOBILE_MAPS_MAKE_ROUTE = SingleEventHook([
    {'path': [
        'place.make-route'
    ],
    },
])

MOBILE_MAPS_SITE = SingleEventHook([
    {'path': [
        'place.open-site',
        'place.open-adv-product',
        'place.open-adv-promo-url'
    ],
    },
])

MOBILE_MAPS_PHONE = SingleEventHook([
    {'path': [
        'place.make-call'
    ],
    },
])

NAVI_DEEP_USE = SingleEventHook([
    {'path': [
        'route.make-route',
        "place.make-route",
        "route.add-via-point",
        "place.open-site",
        "place.make-call",
    ],
    },
])

NAVI_GOOD_USE = SingleEventHook([
    {'path': [
        'map.show-minicard',
        'place.open-place-view'
    ],
    },
])

NAVI_MAKE_ROUTE = SingleEventHook([
    {'path': [
        'route.make-route',
        "place.make-route",
        "route.add-via-point",
    ],
    },
])

NAVI_SITE = SingleEventHook([
    {'path': [
        "place.open-site",
    ],
    },
])

NAVI_PHONE = SingleEventHook([
    {'path': [
        'place.make-call'
    ],
    },
])

CLICKS = {
    'maps': {
        'good_use': MAPS_GOOD_USE,
        'deep_use': MAPS_DEEP_USE,
        'make_route': MAPS_MAKE_ROUTE,
        'open_site': MAPS_SITE,
        'good_use_map':MAPS_GOOD_USE_MAP,
        'good_use_serp':MAPS_GOOD_USE_SERP
    },
    'mobile_maps': {
        'good_use': MOBILE_MAPS_GOOD_USE,
        'deep_use': MOBILE_MAPS_DEEP_USE,
        'make_route': MOBILE_MAPS_MAKE_ROUTE,
        'open_site': MOBILE_MAPS_SITE,
        'make_call': MOBILE_MAPS_PHONE
    },
    'navi': {
        'good_use': NAVI_GOOD_USE,
        'deep_use': NAVI_DEEP_USE,
        'make_route': NAVI_MAKE_ROUTE,
        'open_site': NAVI_SITE,
        'make_call': NAVI_PHONE
    }
}