import pandas as pd
import random
from retentioneering import init_config

df = pd.read_csv('zero_day_rubric_sessions', sep='\t')

# сортировка перед применением Retentioneering
df = df.sort_values(['FullSessionIDHash','row_num'])
# выравниваем разрядность row_num (нужно для корректного упорядочивания в Retentioneering)
df.row_num += 1000000

# фильтрация событий
# удаляем технические события (много "технических" перетеканий друг в друга с search.rubric_search)
df = df[df.EventName != 'search.get-search-results']
df = df[df.EventName != 'mapkit_search.request']

# задаем конфиг
# успех - рубричный поиск
# неуспех - окончание сессии без рубричного поиска
init_config(
    experiments_folder='mobile-maps',
    index_col='FullSessionIDHash',
    event_col='EventName',
    event_time_col='row_num',
    positive_target_event='search.rubric_search',
    negative_target_event='leave',
    neg_target_definition={}
)

# трансформация датасета в формат Retentioneering
df = df.retention.prepare()

# сортировка после prepare
df = df.sort_values(['FullSessionIDHash','row_num'])

# получение 10 самых популярных ребер "EventName --> next_event" (для анализа адекватности датасета)
edgelist = df.retention.get_edgelist(edge_col='FullSessionIDHash', edge_attributes='users_nunique', norm=True)
edgelist_sorted = edgelist.sort_values('users_nunique', ascending=False)
edgelist_sorted.head(10)

# топ-5 событий перед рубричным поиском (как делают поиск?)
edgelist_sorted[edgelist_sorted.next_event == 'search.rubric_search'].head()
# топ-5 событий после рубричного поиска (зачем делают поиск?)
edgelist_sorted[edgelist_sorted.EventName == 'search.rubric_search'].head()

# визуализация графа
df.retention.plot_graph(thresh=0.05, width=800, height=800)
