"""module defining joining functions"""

from nile.api.v1 import (
    aggregators as na,
)


def join_tables(mapreqans, appmetrica):
    """return joined table for getting appPlatform"""
    stream = appmetrica.join(
        mapreqans, type='left', by_left='uuid', by_right='raw_uuid'
    ).groupby(
        'date', 'search_type', 'app_platform'
    ).aggregate(
        requests=na.sum('requests'),
        serpids=na.sum('serpids')
    ).sort(
        'date',
        'app_platform',
        'search_type'
    )
    return stream
