# coding=utf-8

from qb2.api.v1 import (
    filters as qf,
    extractors as qe
)


def extract_from_mobile_metrika(
        job,
        dates,
        additional_fields=None,
        additional_filters=None,
        debug_input=None
):
    if additional_fields is None:
        additional_fields = []
    if additional_filters is None:
        additional_filters = []
    if debug_input is None:
        debug_input = []

    path2log = '$mobmetrika/{}'.format(dates)
    return job.table(path2log).debug_input(debug_input) \
        .qb2(log='metrika-mobile-log',
             fields=['event_date',
                     'event_datetime',
                     'event_number',
                     'event_type',
                     'event_name',
                     'app_platform',
                     'app_version',
                     qe.log_field('LocationSource'),
                     qe.mobile.event_value('event_value'),
                     'device_id',
                     ] + additional_fields,
             filters=[] + additional_filters,
             intensity='default'
             )


def get_user_id(puid, device_id):
    """
    В поле puid пишется AccountID пользователя. Считаем, что при залогине и разлогине на одном девайсе юзер должен
    получать разные данные. Действия залогиненного пользователя на разных девайсах будут объединяться, а действия
    незалогиненного прикреплены к конкретному девайсу. Возможное улучшение: склейка устройств с помощью Крипты.
    """
    if puid not in ('', 'None', 'Null', 'null', None):
        return str(puid)
    else:
        return str(device_id)


def main(job, dates):
    fields = [
        'session_id',
        'puid',
        'geo_id',
        qe.unfold_geo_prefixes('geo_path', 'geo_id'),
        'event_time_offset',
        qe.custom('u_id',
                  get_user_id,
                  'puid',
                  'device_id')
    ]
    filters = [
        qf.apps_projects('Mobile_Soft_Maps'),
        qf.equals('event_type', 'EVENT_CLIENT'),
        qf.equals('session_type', 'SESSION_FOREGROUND'),  # не берем в расчет ведение в фоне
        qf.defined('app_platform', 'app_version', 'event_date'),
        qf.one_of('app_platform', ['iOS', 'Android', 'android'])
    ]

    parsed_log = extract_from_mobile_metrika(
        job,
        dates,
        fields,
        filters
    )

    return parsed_log
