import math

import numpy as np


def deg2rad(deg):
    return deg * (np.pi / 180)


def get_dist_in_km((lat1, lon1), (lat2, lon2)):
    R = 6371
    dLat = deg2rad(lat2 - lat1)
    dLon = deg2rad(lon2 - lon1)
    a = np.sin(dLat / 2) * np.sin(dLat / 2) + \
        np.cos(deg2rad(lat1)) * np.cos(deg2rad(lat2)) * \
        np.sin(dLon / 2) * np.sin(dLon / 2)

    c = 2 * math.atan2(np.sqrt(a), math.sqrt(1 - a))
    d = R * c
    return d
