use hahn;
PRAGMA yson.DisableStrict; 
PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';
PRAGMA simplecolumns;

$base_path =  "home/geo-analytics/" || CurrentAuthenticatedUser() || "/" || "mama841/yabs_testing" ;
$oid_capture = Re2::Capture(".*oid=(\\d+)");
$capture = ($src, $func) -> {
    RETURN $func($src)._1; 
};

--Готовим список рекламных пои для ранжирования. Список формируем на определенную дату. Берем из таблиц бекенда + spendings_log

--дата, на которую будем формировать список рекламных пои
$date =  '2020-03-20';

$active_gp = select distinct permalink from `//home/geoadv/geoproduct/intermediate/spendings_log` where dt=$date;

$zooms = (
    select permalink,
    zmin,
    flagSuperPoi,
    gp
    from (
        select 
            cast($capture(uri,$oid_capture) as Int64) as permalink,
            zmin,
            gp,
            IF(layer = "poi.SuperPOI", 1, 0) as flagSuperPoi
        from `//home/maps/front/reports/maps-layers-data/prod/20.03.20-0/cis1` 
        where zmin is not null
    )
    where permalink is not null
    group by permalink, zmin, gp, flagSuperPoi
);

--выгружаем общий список пои, которые отображаются на карте
$path = $base_path || '/distr_fact';
INSERT INTO $path with truncate
select * from $zooms;

--выгружаем список рекламных пермалинков
$path = $base_path || '/yabs_gp';
INSERT INTO $path with truncate
select 
    coalesce(a.permalink, b.permalink) as permalink 
from 
(select distinct permalink from $zooms where gp == '1' or permalink in $active_gp) as a
full join $active_gp as b
using (permalink);

