use hahn;
pragma yson.DisableStrict;
PRAGMA simplecolumns;

$base_path =  "home/geo-analytics/" || CurrentAuthenticatedUser() || "/" || "mama841/yabs_testing" ;


$E=0.0818191908426;

--скрипт расчета тайлов для кликов


--формулы для расчета тайла
$get_p = ($zoom) -> {
return Math::Pow(2, $zoom+8)/2;
};

$get_beta = ($lat) -> {
return (Math::Pi() * $lat) / 180;
};

$get_phi = ($beta) -> {
return (1-$E*Math::Sin($beta))/(1+$E*Math::Sin($beta))
};

$get_O = ($beta,$phi) -> {
return Math::Tan(Math::Pi()/4+$beta/2)*Math::Pow($phi,$E/2)
};


--выгружаем логи
$logs_poi_clicks = (
select userid,
    session_date,
    permalink,
    zoom_click_poi_layer,
    lat,
    lon,
    name,
    is_geoproduct,
    is_super_poi
from `//home/geo-analytics/sinvic/mama825/clean/orgstat/orgstat_not_flatten_2020_01`
where 
    service in ('mobile_maps', 'desktop_maps')
    and String::ToLower(region) == 'москва и московская область'
    and zoom_click_poi_layer is not null --времено пока есть логи со старым логированием кликов
);

$table_path = $base_path || '/logs_poi_clicks';
insert into $table_path with truncate
select * from $logs_poi_clicks;


--считаем общее количество кликов по пои на всех зумах за весь период
$poi_cnt = (
select 
    permalink, 
    count(*) as cnt 
from $logs_poi_clicks
group by permalink
);

--создаем табличку с диапазоном зумов, на которых будем проводить ранжирование
$zoom_range = (select * 
from (
    select ListFromRange(13,20) as zoom
    )
flatten list by zoom);

--считаем тайлы для каждого пои из логов. считаем для каждого зума, вне зависимости от фактического расположения пои, чтобы можно было повышать/понижать пои на подложке 
$poi_tails = (
select distinct permalink,
    zoom,
    tail_y,
    tail_x
from (
    select 
        permalink,
        zoom,
        lat,
        lon,
        $get_p(zoom)*(1 + lon / 180) as x,
        $get_p(zoom)*(1-Math::Log($get_O($get_beta(lat),$get_phi($get_beta(lat))))/Math::Pi()) as y,
        Math::Floor($get_p(zoom)*(1 + lon / 180) / 256) as tail_x,
        Math::Floor($get_p(zoom)*(1-Math::Log($get_O($get_beta(lat),$get_phi($get_beta(lat))))/Math::Pi()) / 256) as tail_y
    from (select distinct permalink, lat, lon from $logs_poi_clicks) as l
    cross join $zoom_range as z    
    )
);


$path_poi_data = $base_path || '/poi_data';
--добавляем общее количество кликов и заливаем в итоговую таблицу
insert into $path_poi_data with truncate
select z.permalink as permalink,
    z.zoom as zoom,
    z.tail_y as tail_y,
    z.tail_x as tail_x,
    p.cnt as cnt
from $poi_tails as z
join $poi_cnt as p
using (permalink)
order by permalink;

