use hahn;
pragma yson.DisableStrict;
PRAGMA simplecolumns;

$base_path =  "home/geo-analytics/" || CurrentAuthenticatedUser() || "/" || "mama841/yabs_testing" ;
$min_zoom_poi = $base_path || '/min_zoom_lists';
$path_poi_data = $base_path || '/poi_data';
$poi_src = select * from $path_poi_data;
$path_gp = $base_path || '/yabs_gp';

--скрипты с ранжированием

$poi_gp = select * from $path_gp;
$is_gp = ($permalink) ->
{
return $permalink in $poi_gp
};

$cnt_to_show = 4;

--изменяем количество кликов по пои в зависимости от условий ранжирования; тут умножаем на 2 рекламные клики
$poi_src_yabs_add = (
select 
    permalink,
    zoom,
    tail_y,
    tail_x,
    if($is_gp(permalink), cnt * 2, cnt) as cnt 
from $poi_src
);

------------------------------------------------------------------------------------------------------------------------
--путь, где будут хранится таблицы с ранжированием
$common_prefix = '/min_zoom_data/poi_on_min_zoom_';


$zoom_range = select ListFromRange(13,20);

--табличка для пои, которые уже были проранжированы
$path_used_permalinks = $base_path || '/used_permalinks';
insert into $path_used_permalinks with truncate
select cast(-1 as Int64) as permalink;
commit;


DEFINE ACTION $insert_data($zoom) as
--создаем таблички с ранжированными пои, для каждого зума - своя итерация

--отбираем пои, которые еще не появились на предыдущих зумах в ходе ранжирования
        $src = (
        select 
            permalink,
            zoom,
            tail_y,
            tail_x,
            cnt
        from $poi_src_yabs_add
        where zoom = $zoom 
        and permalink not in (select distinct permalink from $path_used_permalinks)
        );
        
        -- $path_to_insert =  $base_path || $common_prefix || cast($zoom as String) || '_src';
        -- insert into $path_to_insert with truncate
        -- select * from $src
        -- order by permalink;
        
--ранжируем: берем пои на ранжируемом зуме в конкретных тайлах, и ранжируем по убыванию общего количества кликов        
        $poi_ranged = (
        select 
            permalink,
            zoom,
            tail_y,
            tail_x,
            cnt,
            ROW_NUMBER() over w as rnk
        from $src
        window w as (partition by zoom, tail_x, tail_y order by cnt desc)
        );
        
        -- $path_to_insert =  $base_path || $common_prefix || cast($zoom as String) || '_ranged';
        -- insert into $path_to_insert with truncate
        -- select * from $src
        -- order by zoom,tail_y,
        --     tail_x,
        --     cnt desc;

--модифицируем плотность на тайл в зависимости от зума (на 19 зуме надо показать все оставшиеся пои, поэтому плотность не рассматриваем)     
        $poi_ranged_filtered = (
        select permalink,
        zoom,
        tail_y,
        tail_x,
        cnt,
        rnk
        from $poi_ranged
        where 
            if($zoom == 19, True, rnk <= if(zoom <=13, 1, if(zoom <= 16, 3, $cnt_to_show)))
        );

--заливаем табличку с ранжированием на зуме        
        $path_to_insert =  $base_path || $common_prefix || cast($zoom as String);
        insert into $path_to_insert with truncate
        select * 
        from $poi_ranged_filtered
        order by zoom,
            tail_y,
            tail_x,
            rnk;

--обновляем табличку с использованными пои        
        insert into $path_used_permalinks
        select distinct permalink from $poi_ranged_filtered;
        commit;

end define;
--итерационный процесс ранжирования
EVALUATE FOR $zoom IN $zoom_range 
    DO $insert_data($zoom)
;

commit;















