use hahn;
pragma yson.DisableStrict;
PRAGMA simplecolumns;

$base_path_yabs =  "home/geo-analytics/" || CurrentAuthenticatedUser() || "/" || "mama841/yabs_testing" ;
$common_prefix = $base_path_yabs || '/min_zoom_data';
$base_path =  "home/geo-analytics/" || CurrentAuthenticatedUser() || "/" || "mama841" ;
$cis1_items_path = $base_path || '/cis1_items';
$path_gp = $base_path_yabs || '/yabs_gp';

--объединяем таблички с ранжированием по зумам и джоиним с данными картографа

$poi_gp = select * from $path_gp;
$min_zoom_data = (select permalink, zoom as min_zoom
from range($common_prefix)
);

$poi_zoomed = (
    select
    distinct name, --чтобы убрать дубликаты
    permalink,
    lon,
    lat,
    min_zoom,
    is_geoproduct,
    icon_class,
    disp_class,
    disp_class_tweak
    from (select 
        cis1.name as name,
        cis1.permalink as permalink,
        cis1.lon as lon,
        cis1.lat as lat,
        zoom.min_zoom as min_zoom,
        p.permalink is not null as is_geoproduct,
        cis1.icon_class as icon_class,
        cis1.disp_class as disp_class,
        cis1.disp_class_tweak as disp_class_tweak
    from $cis1_items_path as cis1
    join $min_zoom_data as zoom on cis1.permalink = zoom.permalink
    left join $poi_gp as p on p.permalink = cis1.permalink
    ) as a
);

$table_path = $base_path_yabs || '/res_within_tail';

insert into $table_path with truncate
select * from $poi_zoomed;

select * from $poi_zoomed;