use hahn;
PRAGMA yson.DisableStrict; 
PRAGMA yt.PoolTrees = 'physical';
PRAGMA yt.TentativePoolTrees = 'cloud';

$res = "home/geo-analytics/" || CurrentAuthenticatedUser() || "/" || "mama841/testing_system/cis_items" ;

$cis1 = 'home/maps/core/garden/stable/ymapsdf/latest/cis1';
$ft = $cis1 || '/ft';
$ft_geom = $cis1 || '/ft_geom';
$ft_source = $cis1 || '/ft_source';
$ft_type = $cis1 || '/ft_type';
$ft_nm = $cis1 || '/ft_nm';
$ft_rubric = $cis1 || '/ft_rubric';

$pick_icon_class = ($v1, $v2) -> {
    return if($v1 != '', $v1, $v2);
};

$patch_icon_class = ($icon_class) -> {
    return String::ReplaceAll($icon_class, ' ', '_');
};

$ft_rubric_ex = (
    select
        rubric.rubric_id as rubric_id,
        $pick_icon_class(rubric.icon_class, parent_rubric.icon_class) as icon_class,
        rubric.p_rubric_id as parent_rubric_id
    from $ft_rubric as rubric
    join $ft_rubric as parent_rubric on rubric.p_rubric_id = parent_rubric.rubric_id
);

$items = (
    select
        ft.ft_id as ft_id,
        ft_nm.name as name, 
        cast(ft_source.source_id as Int64) as permalink,
        ft.ft_type_id as ft_type_id,
        cast(ft.rubric_id as Int64) as rubric_id,
        $patch_icon_class($pick_icon_class(ft.icon_class, ft_rubric.icon_class)) as icon_class,
        ft_type.name as ft_type_name,
        ft.disp_class as disp_class,
        ft.disp_class_tweak as disp_class_tweak,
        ft_geom.xmin as lon,
        ft_geom.ymin as lat
    from $ft as ft
    join $ft_geom as ft_geom on ft.ft_id = ft_geom.ft_id
    join $ft_source as ft_source on ft.ft_id=ft_source.ft_id
    join $ft_type as ft_type on ft.ft_type_id = ft_type.ft_type_id
    join $ft_nm as ft_nm on ft.ft_id = ft_nm.ft_id
    join $ft_rubric_ex as ft_rubric on ft.rubric_id = ft_rubric.rubric_id
    where 
        ft_source.source_type_id = 1
        and ft_nm.is_local
        and ft_nm.name_type = 0 
        and not ft_nm.is_auto
        and ft_nm.lang = 'ru'
);

$table_path = $res || '/cis1_items';

INSERT INTO $table_path with truncate
SELECT distinct  ft_id,
        name, 
        permalink,
        ft_type_id,
        rubric_id,
        icon_class,
        ft_type_name,
        disp_class,
        disp_class_tweak,
        lon,
        lat 
FROM $items
GROUP BY t_id,
        name, 
        permalink,
        ft_type_id,
        rubric_id,
        icon_class,
        ft_type_name,
        disp_class,
        disp_class_tweak,
        lon,
        lat;
