#!/usr/bin/env python3

import sys
import csv
import json
from collections import OrderedDict

def main():
    file_path = sys.argv[1]
    features = []
    with open(file_path) as fd:
        dialect = csv.Sniffer().sniff(fd.readline())
        fd.seek(0)
        reader = csv.reader(fd, dialect=dialect)
        header = next(reader)
        names = dict()
        for i, name in enumerate(header):
            names[name] = i
        name_idx = names['name']
        permalink_idx = names['permalink']
        icon_class_idx = names['icon_class']
        lon_idx = names['lon']
        lat_idx = names['lat']
        min_zoom_idx = names['min_zoom']
        is_gp = names['is_geoproduct']
        for row in reader:
            name = row[name_idx]
            permalink = row[permalink_idx]
            icon_class = row[icon_class_idx]
            lon = round(float(row[lon_idx]),4)
            lat = round(float(row[lat_idx]),4)
            min_zoom = int(row[min_zoom_idx])
            gp = row[is_gp]
            feature = OrderedDict(
                type='Feature',
                geometry=OrderedDict(
                    type='Point',
                    coordinates=(lon, lat)
                ),
                properties=OrderedDict(
                    name=name,
                    permalink=permalink,
                    gp=gp,
                    icon_class=icon_class,
                    zmin=min_zoom,
                    zmax=21,
                ),
            )
            features.append(feature)
    obj = OrderedDict(
        type='FeatureCollection',
        features=features,
    )
    str_content = json.dumps(obj, indent=0, ensure_ascii=False)
    print(str_content.replace('\n',''))

if __name__ == '__main__':
    main()