USE hahn;

PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

DECLARE $start_date as STRING;
DECLARE $finish_date as STRING;
DECLARE $v as STRING;

$base_path = '//home/geo-analytics/poi_rank/' || $v;
$result_path = $base_path || '/orgclicks';

$processed_joins = (
    SELECT *
    FROM (
        SELECT *
        FROM RANGE(`home/geoadv/statistics/clicks/processed_join/desktop_maps`, $start_date, $finish_date)
        UNION ALL
        SELECT *
        FROM RANGE(`home/geoadv/statistics/clicks/processed_join/touch_maps`, $start_date, $finish_date)
        UNION ALL
        SELECT *
        FROM RANGE(`home/geoadv/statistics/clicks/processed_join/mobile_maps`, $start_date, $finish_date)
    )
    WHERE is_robot_by_metrika IS NULL
);

-- TODO: по-хорошему надо знать в какие дни пермалинк был опубликован и считать среднюю статистику за опубликованный день
$stat_per_day = (
    SELECT
        permalink,
        COUNT(1) as total_opens,
        COUNT_IF(bc_source = 'poi') as poi_opens,
        COUNT_IF(bc_type = 'discovery') as discovery_opens,
        COUNT_IF(bc_type = 'not_discovery') as not_discovery_opens,
        COUNT_IF('build_route' IN actions) as build_route,
        COUNT_IF('any_site' IN actions) as any_site,
        COUNT_IF('show_phone' IN actions OR 'make_call' IN actions) as phone,
        COUNT_IF('open_photo' IN actions) as open_photo,
        COUNT_IF('read_review' IN actions) as read_review
    FROM $processed_joins as a
    INNER JOIN (
        SELECT permalink, COALESCE(duplicate_company_id, permalink) AS head_permalink
        FROM RANGE(`//home/sprav/altay/prod/history/company`, $finish_date, $finish_date)
    ) AS b
    ON a.permalink = b.permalink
    GROUP BY b.head_permalink as permalink
);

INSERT INTO $result_path WITH TRUNCATE
SELECT *
FROM $stat_per_day
ORDER BY permalink;
