USE hahn;
PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

DECLARE $v AS STRING;


$base_path = "//home/geo-analytics/poi_rank/" || $v;
$orgsprav_out_path = $base_path  || "/orgsprav";
$clicks_path = $base_path || "/orgclicks";
$out_all_path = $base_path || "/data/all";


$data_all = (
    SELECT o.permalink AS permalink,
           geo_id,
           lat,
           lon,
           poi_opens as total_opens,
           is_geoproduct
    FROM $orgsprav_out_path AS o
    LEFT JOIN $clicks_path AS cl
    ON cl.permalink = o.permalink
);

INSERT INTO $out_all_path WITH TRUNCATE
SELECT * FROM $data_all;
