USE hahn;
PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

DECLARE $v AS STRING;
DECLARE $prod_rank_date AS STRING;

$base_path = '//home/geo-analytics/poi_rank/' ;
$out_all_path = $base_path || $v || '/data/all';
$out_filter_path =  $base_path || $v || '/filtered/moscow/data';

$icon_info_path = $base_path || "prod/icon_info";
$icon_info_filter_path = $base_path || $v || "/filtered/moscow/icon_info";
$orgsprav_path = $base_path || $v  || "/orgsprav";

$prod = $base_path || "prod/rank/" || $prod_rank_date;
$prod_out_path =  $base_path || $v  || "/filtered/moscow/prod_rank_" || $prod_rank_date;

$data_filter = (
    SELECT permalink,
           geo_id,
           lat,
           lon,
           total_opens,
           is_geoproduct
    FROM $out_all_path AS m
    WHERE 
        String::ToLower(Geo::RoundRegionByLocation(lat, lon, 'region').name) = 'москва и московская область'
);

INSERT INTO $out_filter_path WITH TRUNCATE
SELECT * FROM $data_filter;

INSERT INTO $icon_info_filter_path WITH TRUNCATE
SELECT i.*
FROM range($icon_info_path) AS i
JOIN $orgsprav_path AS org
ON org.permalink = i.permalink
WHERE 
    String::ToLower(Geo::RoundRegionByLocation(lat, lon, 'region').name) = 'москва и московская область';

INSERT INTO $prod_out_path WITH TRUNCATE
SELECT p.*
FROM $prod AS p
JOIN $orgsprav_path AS o
ON o.permalink = p.permalink
WHERE 
    String::ToLower(Geo::RoundRegionByLocation(lat, lon, 'region').name) = 'москва и московская область';
