USE hahn;
PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

$base_path = '//home/geo-analytics/poi_rank/';
$icon_info_out_path = $base_path || "prod/icon_info/";


$newest_release_folder  = (
    SELECT
        AGGREGATE_LIST(Path) as paths
    FROM FOLDER('//home/maps/core/garden/stable/ymapsdf/latest')
    );
    

$pick_icon_class = ($v1, $v2) -> {
    RETURN IF($v1 != '', $v1, $v2);
};

$patch_icon_class = ($icon_class) -> {
    RETURN String::ReplaceAll($icon_class, ' ', '_');
};

DEFINE ACTION $insert_data($folder) as
    $region = ListLast(String::SplitToList($folder, '/'));
    $cis1 = 'home/maps/core/garden/stable/ymapsdf/latest/' || $region;
    $ft = $cis1 || '/ft';
    $ft_geom = $cis1 || '/ft_geom';
    $ft_source = $cis1 || '/ft_source';
    $ft_type = $cis1 || '/ft_type';
    $ft_nm = $cis1 || '/ft_nm';
    $ft_rubric = $cis1 || '/ft_rubric';


    $ft_rubric_ex = (
    SELECT 
        rubric.rubric_id AS rubric_id,
        $pick_icon_class(rubric.icon_class, parent_rubric.icon_class) AS icon_class,
        rubric.p_rubric_id AS parent_rubric_id
    FROM $ft_rubric AS rubric
    JOIN $ft_rubric AS parent_rubric on rubric.p_rubric_id = parent_rubric.rubric_id
    );
    
    $items = (
        SELECT
            ft_nm.name as name,
            CAST(ft_source.source_id AS Int64) AS permalink,
            COALESCE($patch_icon_class($pick_icon_class(ft.icon_class, ft_rubric.icon_class)), '') AS icon_class,
            ft.disp_class AS disp_class,
            ft.disp_class_tweak AS disp_class_tweak
        FROM $ft AS ft
        JOIN $ft_geom AS ft_geom on ft.ft_id = ft_geom.ft_id
        JOIN $ft_source AS ft_source on ft.ft_id=ft_source.ft_id
        JOIN $ft_type AS ft_type on ft.ft_type_id = ft_type.ft_type_id
        JOIN $ft_nm AS ft_nm on ft.ft_id = ft_nm.ft_id
        LEFT JOIN $ft_rubric_ex AS ft_rubric on ft.rubric_id = ft_rubric.rubric_id
        WHERE  
            ft_source.source_type_id = 1
            AND ft_nm.is_local
            AND (ft_nm.name_type = 0 OR ft_nm.name_type = 1)
            AND NOT ft_nm.is_auto
    );
    $path = $icon_info_out_path || $region;
    INSERT INTO $path WITH TRUNCATE
    SELECT  permalink,
            MIN_BY(name, LENGTH(name)) AS name,
            icon_class,
            disp_class,
            disp_class_tweak
    FROM $items
    GROUP BY permalink,
            icon_class,
            disp_class,
            disp_class_tweak;

END DEFINE;       

EVALUATE FOR $pair IN $newest_release_folder
    DO $insert_data($pair)
ELSE
    DO EMPTY_ACTION();
    
commit;
