USE hahn;

PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

DECLARE $rnk_date as STRING;
DECLARE $v as STRING;


$base_path = "//home/geo-analytics/poi_rank/";
$orgsprav_out_path = $base_path || $v || "/orgsprav";
$maps_out_path = $base_path  || "prod/rank/" || $rnk_date;
$date_capture = Re2::Capture(".*(\\d{2}.\\d{2}.\\d{2})");

$date_capture = Re2::Capture(".*(\\d{2}.\\d{2}.\\d{2})");
$release_capture = Re2::Capture("-(\\d+)");
$oid_capture = Re2::Capture(".*oid=(\\d+)");
$capture = ($src, $func) -> {
    RETURN $func($src)._1; 
};
$parse1 = DateTime::Parse("%Y.%m.%d");
$replace = Re2::Replace("\\.");

$newest_release_folder  = (
    SELECT
        Path
    FROM FOLDER('//home/maps/front/reports/maps-layers-data/prod')
    WHERE 
        $replace("20" || $capture(Path,$date_capture), '-')=$rnk_date
    ORDER BY $capture(Path, $release_capture) DESC
    LIMIT 1
    );

$maps_layers_data = (
    SELECT 
        permalink,
        MIN(zmin) AS min_zoom,
        SOME(is_geoproduct) AS is_geoproduct
    FROM (
        SELECT 
            cast($capture(uri,$oid_capture) as Int64) AS permalink,
            zmin,
            gp == '1' AS is_geoproduct
        FROM RANGE($newest_release_folder)
        WHERE CAST($capture(uri,$oid_capture) AS Int64) IS NOT NULL
        )
    GROUP BY permalink
    );
$orgsprav = (
    SELECT comp.permalink as permalink,
           lat,
           lon,
           Geo::RegionByLocation(lat, lon).id as geo_id,
           main_rubric_id as main_rubric_id,
           main_rubric_name_ru,
           rubric_names_ru,
           is_geoproduct
    FROM `//home/sprav/assay/common/company_pretty_format` AS comp
    JOIN $maps_layers_data AS m ON m.permalink = comp.permalink
    );
        
INSERT INTO $orgsprav_out_path WITH TRUNCATE
SELECT *
FROM $orgsprav
ORDER BY permalink;

INSERT INTO $maps_out_path WITH TRUNCATE
SELECT org.permalink AS permalink,
      min_zoom,
      org.is_geoproduct AS is_geoproduct,
      geo_id
FROM $orgsprav AS org
JOIN $maps_layers_data AS m ON m.permalink = org.permalink;
