USE hahn;
PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

DECLARE $v AS STRING;
DECLARE $prod_rank_date AS STRING;

$base_path = '//home/geo-analytics/poi_rank/';

$prod = $base_path || $v || '/filtered/moscow/prod_rank_' || $prod_rank_date;
$rank = $base_path || $v || '/filtered/moscow/rank';
$orgsprav = $base_path || $v || '/orgsprav';
$rank_metrics_path = $base_path || $v || '/filtered/moscow/rank_metrics';


$fact = (
    SELECT col AS zoom, 
           permalink 
    from (
        SELECT min_zoom,
            ListFromRange(UNWRAP(IF(min_zoom <= 12, 13, min_zoom)), 20) AS col,
            p.permalink AS permalink
        FROM $prod AS p
        JOIN $orgsprav AS o ON o.permalink = p.permalink
        WHERE
            p.is_geoproduct
    )
    FLATTEN LIST BY col
);

$fact_2 = (
    SELECT zoom, 
        COUNT(DISTINCT permalink) AS cnt_fact
    FROM $fact
    GROUP BY zoom
);

$yabs_rank = (
    SELECT col AS zoom, 
        permalink 
    FROM (
        SELECT min_zoom,
            ListFromRange(UNWRAP(min_zoom), 20) as col,
            permalink 
        FROM $rank
        WHERE 
            is_geoproduct
    )
    FLATTEN LIST BY col
);

$yabs_rank_2 = (
    SELECT zoom, 
        COUNT(DISTINCT permalink) AS cnt_rnk
    FROM $yabs_rank
    GROUP BY zoom
);

INSERT INTO $rank_metrics_path WITH TRUNCATE
SELECT f.zoom AS zoom,
    cnt_fact AS prod,
    cnt_rnk AS rank
FROM $fact_2 AS f
JOIN $yabs_rank_2 AS t2 ON t2.zoom = f.zoom;
