# coding=utf-8
"""
Из логов веб-карт достаем события показов директа
"""
import argparse
import base64

from qb2.api.v1 import filters as qf, extractors as qe
from nile.api.v1 import clusters


def decode_logid(logid_encoded):
    decoded_dict = {}
    if logid_encoded is None:
        return decoded_dict

    sources = logid_encoded.split(',')
    for source in sources:
        complex_kv_pair = base64.b64decode(source)
        kv_pairs_list = complex_kv_pair.split(';')
        # Пока для каждого источника предполагается только 2 параметра - имя источника и id в этом источнике
        if len(kv_pairs_list) != 2:
            continue
        source_type = kv_pairs_list[0].split('=')[1]
        source_id = kv_pairs_list[1].split('=')[1]
        if source_type in decoded_dict:
            pass
        decoded_dict[source_type] = source_id

    return decoded_dict


def main(start_date, end_date, job_root):
    cluster = clusters.Hahn().env(
        templates={
            'redir_log_extracts': '//home/geo-analytics/heyroman/extracts/bebr',
            'job_root': job_root,
        }
    )
    job = cluster.job()

    job.table(
        "{0}/{1}".format('$redir_log_extracts', '{%s..%s}' % (start_date, end_date))
    ).qb2(
        mode='records',
        intensity='data',
        memory_limit=800,
        log='redir-log-bebr',
        fields=[
            'date',
            'event_datetime',
            'yandexuid',
            'puid',
            'reqid',
            qe.dictitem('permalink', 'vars'),
            qe.dictitem('logId', 'vars'),
            qe.custom('decoded_logId', decode_logid, 'logId'),
        ],
        filters=[
            # дефолтная фильтрация
            qf.defined('date', 'yandexuid', 'session_id', 'event_timestamp'),
            qf.equals('pid', '30'),
            qf.default_filtering('redir-log-bebr'),

            # фильтрация нужных событий
            qf.equals('path', 'maps_www.map.search_results.placemark'),
            qf.equals('event_type', 'show'),
            qf.custom(lambda vars: vars and vars.get('type') == 'geodirect'),
        ]
    ).put(
        '$job_root/{}:{}'.format(start_date, end_date)
    )

    job.run()
    print


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--start_date', required=True, help='Первая дата за которую нужно посчитать метрики')
    parser.add_argument('--end_date', required=True)
    parser.add_argument('--job_root', default='//tmp/search-direct-show')
    args = parser.parse_args()
    main(args.start_date, args.end_date, args.job_root)
