### clicks_description.json

Содержит описание кликов на карточке места в картах и навигаторе.

- Пример использования в JAM – https://a.yandex-team.ru/arc/trunk/arcadia/statbox/jam/jobs/regular_jobs/geo-analytics/statadhoc-13309/step1
- Пример использования в интерфейсе YQL – https://yql.yandex-team.ru/Operations/XfdYBp9LnktkMfOKoEDY2Xe8olsplOaOz41_exR4H0Y=

Структура одного элиаса: 
```
{
    "alias": "new_rate",  // обязательное поле: название несет в себе бизнес логику события
    "ru_name": "Отправка новой оценки",  // обязательное поле
    "events":  // обязательное поле: перечисляем в списке предикаты событий для этого элиаса
        [
            {
            "label": "rate",  // обязательное поле, если используешь regexp для сервиса maps
            "regexp": ".*\\.preview_card\\..*\\.(star)$",  // регулярное выражение. Внутри одного предиката может быть либо 1 поле "regexp", либо одно поле "name"
            "name": 'maps_www.preview_card.star',  // название ноды/события. См. "regexp"
            "params": {  // опциональное поле. Предикат на параметры события. Для сервиса maps НЕ РАБОТАЕТ
              "tab_title": "reviews"
            },
            "_comment": "something",  // опциональное поле
            }
        ]
    }
```

### Как обновлять clicks_description.json для service=maps

Регулярки, описанные в блоке service=maps, используются разработкой веб-карт для выполнения авто-тестов на логирование. Поэтому при обновлении информации в этом блоке нужно придерживаться определенной инструкции. 
Если ваши изменения не касаются полей **alias, label и regexp**, то к вам эта инструкция не относится.

Что делать при добавлении нового элиаса или добавлении новых регулярок:
1. Придумать для каждой регулярки **label** по аналогии с уже существующими
2. Создать тикет в MAPSUI, в начале названия написать [A] (аналогично с https://st.yandex-team.ru/MAPSUI-17646)
3. Отправить PR, привязанный к этому тикету, с новым/новыми alias, label и regexp, дождаться успешного прохождения аркадийных автотестов
4. При необходимости добавить makishvili@ в наблюдатели

После этого разработчик аппрувит PR, если label и регулярка его устраивают, и добавляет тест, забирая регулярку уже из смерженного clicks_description.
