import json
from library.python import resource


def load_rubrics_json(filename="rubrics.json"):
    arcadia_resource = resource.find("/analytics/geo/maps/common/rubrics/rubrics_json")
    if arcadia_resource is not None:
        rubrics_description = json.loads(arcadia_resource.decode("utf-8"))
    else:
        rubrics_description = json.load(file(filename))
    return rubrics_description


def get_rubrics_description(filename="rubrics.json"):
    return dict(
        (rubric["id"], rubric) for rubric in load_rubrics_json(filename)
    )


def get_rubric_id_mapping(filename="rubrics.json"):
    return dict(
        (rubric["id_backa"], rubric["id"]) for rubric in load_rubrics_json(filename)
    )
