PRAGMA yt.InferSchema = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;

-- CONSTANTS --

$RESULT_PATH = "//home/geo-analytics/navi/reports/events_snapshot";

$MAX_UNIQ_ATTR_VALUES = 20;

$API_KEYS = ("30488",);

$SPLIT_CHAR = "|";

-- FUNCTIONS --

$packList = ($lst) -> {
    RETURN String::JoinFromList(ListSortAsc($lst), $SPLIT_CHAR);
};

$unpackList = ($str) -> {
    RETURN String::SplitToList($str, $SPLIT_CHAR);
};

$MIN_OF_BY = ($a, $b, $f) -> {
    RETURN IF($f($a) > $f($b), $b ?? $a, $a ?? $b);
};

$MAX_OF_BY = ($a, $b, $f) -> {
    RETURN IF($f($a) < $f($b), $b ?? $a, $a ?? $b);
};

-- INCLUDES --

PRAGMA Library("metrika_mobile_log.sql");
IMPORT metrika_mobile_log SYMBOLS 
    $metrika_mobile_log,
    $versionToInt;

PRAGMA Library("common.sql");
IMPORT common SYMBOLS 
    $date_format,
    $event_match;

-- PRAGMA yson.DisableStrict;

-- OPERATIONS -- 
use hahn;

$flatten_event_value = (
    SELECT
        api_key,
        platform,
        app_version,
        event_name,
        attr.0 ?? "" as attr_key,
        attr.1 ?? "" as attr_value
    FROM 
    (
        SELECT
            *
        FROM
            $metrika_mobile_log($API_KEYS, $__START_DATE__, $__END_DATE__)
    )
    FLATTEN DICT BY (
        SetUnion(
            event_value,
            AsDict(AsTuple("", "")),
            ($k, $a, $b) -> { RETURN $a ?? $b}
        ) as attr
    )
);
    
$new_report = (
    SELECT
        event_name,
        attr_key,
        IF (
            ListLength(attr_values) <= $MAX_UNIQ_ATTR_VALUES, 
            $packList(attr_values)
        ) as attr_values,
        $packList(platforms) as platforms,
        min_app_version,
        max_app_version
    FROM
    (
        SELECT
            event_name,
            attr_key,
            AGGREGATE_LIST_DISTINCT(
                attr_value, 
                Unwrap(CAST($MAX_UNIQ_ATTR_VALUES + 1 as Uint32))
            ) as attr_values,
            AGGREGATE_LIST_DISTINCT(
                platform
            ) as platforms,
            MIN_BY(app_version, $versionToInt(app_version)) as min_app_version,
            MAX_BY(app_version, $versionToInt(app_version)) as max_app_version
        FROM
            $flatten_event_value
        WHERE
            $event_match(event_name)
            AND $event_match(attr_key)
        GROUP BY event_name, attr_key
    )
);

$old_report = (
    SELECT
        *
    FROM
        $RESULT_PATH
);

INSERT INTO $RESULT_PATH WITH TRUNCATE
SELECT
    event_name,
    attr_key,
    IF (
        ListLength(attr_values) <= $MAX_UNIQ_ATTR_VALUES, 
        $packList(attr_values)
    ) as attr_values,
    $packList(platforms) as platforms,
    min_app_version,
    max_app_version
FROM
(
    SELECT
        old.event_name ?? new.event_name as event_name,
        old.attr_key ?? new.attr_key as attr_key,
        ListUniq(ListExtend(
            $unpackList(old.attr_values),
            $unpackList(new.attr_values)
        )) as attr_values,
        ListUniq(ListExtend(
            $unpackList(old.platforms),
            $unpackList(new.platforms)
        )) as platforms,
        $MIN_OF_BY(
            old.min_app_version, new.min_app_version, $versionToInt
        ) as min_app_version,
        $MAX_OF_BY(
            old.max_app_version, new.max_app_version, $versionToInt
        ) as max_app_version
    FROM
        $old_report as old
        FULL JOIN $new_report as new USING (event_name, attr_key)
)
ORDER BY event_name, attr_key
