import smtplib
from email.mime.text import MIMEText


class Notificator(object):
    __mail_host = 'outbound-relay.yandex.net'
    __domain = 'yandex-team.ru'

    def __init__(self, sender):
        self.sender = sender

    def send(self, recipients, subject, text):
        formatted_recipients = [
            '{recipient}@{domain}'.format(
                recipient=r,
                domain=self.__domain
            ) for r in recipients
        ]

        msg = MIMEText(text, 'html', _charset="utf-8")
        msg['Subject'] = subject
        msg['From'] = self.sender
        msg['To'] = ', '.join(formatted_recipients)

        conn = smtplib.SMTP(self.__mail_host)
        conn.sendmail(self.sender, formatted_recipients, msg.as_string())
        conn.quit()
