PRAGMA yt.InferSchema = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.AutoConvert;
PRAGMA ClassicDivision = 'False';

-- CONSTANTS --

$API_KEYS = ("517959",);
$LAUNCHER_APP_ID = "yandex.auto";
$CARS_ATTR = "//home/carsharing/production/car/cars_attr";

-- INCLUDES --

PRAGMA Library("metrika_mobile_log.sql");
IMPORT metrika_mobile_log SYMBOLS 
    $metrika_mobile_log;

PRAGMA Library("drive_user_sessions.sql");
IMPORT drive_user_sessions SYMBOLS 
    $drive_user_sessions;

PRAGMA Library("common.sql");
IMPORT common SYMBOLS
    $round_period_str;

PRAGMA Library("report.sql");
IMPORT report SYMBOLS
    $TOTAL_VALUE;

-- OPERATIONS -- 
use hahn;

$launcher_version_extractor = ($v) -> {
    $extractor = Re2::Capture("\\d+.\\d+.\\d+");
    RETURN $extractor($v)._0;
};

$launcher_version_to_int = ($v) -> {
    $extractor = Re2::Capture("(\\d+)\\.(\\d+)\\.(\\d+)");
    $v_triplet = $extractor($v);
    
    RETURN CAST(
        CAST($v_triplet._1 as Uint32) * 1000000 + 
        CAST($v_triplet._2 as Uint32) * 1000 + 
        CAST($v_triplet._3 as Uint32) as Uint32
    );
};

DEFINE SUBQUERY $__REPORT__($scale, $start_date, $end_date) AS
    $logs = (
        SELECT
            event_timestamp,
            $launcher_version_extractor(app_version_raw) as app_version_launcher,
            app_id,
            device_id,
            event_name,
            event_value,
            report_environment['IsBooter'] as is_booter,
            String::ToUpper(report_environment['HeadId']) as head_id
        FROM
            $metrika_mobile_log(
                $API_KEYS, 
                $start_date, $end_date
            )
        WHERE
            String::ToLower(model) like '%-yacs%'
            AND device_id IS NOT NULL
            AND device_id != ''
    );
    
    $app_versions = (
        SELECT DISTINCT
            app_version_launcher
        FROM
            $logs
    );
    
    $drive_user_sessions_with_devids = (
        SELECT DISTINCT
            cross_login_permission,
            order_created_at,
            order_completed_at,
            car_id,
            drive.head_id as head_id,
            
            IF (auto.event_timestamp BETWEEN order_created_at AND order_completed_at,
                auto.device_id,
                ''
            ) as device_id
        FROM
            $drive_user_sessions($start_date, $end_date) as drive
            LEFT JOIN 
            $logs as auto
            ON drive.head_id = auto.head_id
        WHERE
            CAST(DateTime::FromSeconds(CAST(order_created_at as Uint32)) as Date) 
                BETWEEN $start_date AND $end_date
            AND is_public_user
    );
    
    $logs_with_drive_sessions = (
        SELECT
            app_id,
            drive.head_id as head_id,
            car_id,
            cross_login_permission,
            order_created_at,
            
            is_booter,
            event_timestamp,
            app_version_launcher,
            event_name,
            event_value
        FROM
            $drive_user_sessions_with_devids as drive
            LEFT JOIN 
            $logs as auto
            ON drive.head_id = auto.head_id AND drive.device_id = auto.device_id
        WHERE
            event_timestamp < order_completed_at
    );
    
    $cars_attr = (
        SELECT DISTINCT
            car_id,
            city,
            model
        FROM
            $CARS_ATTR
    );
    
    SELECT 
        fielddate,
        app_version,
        city,
        model,
        
        COUNT(*) as sessions,
        COUNT_IF(events_count_all > 0) as events_count_all,
        COUNT_IF(events_count_version > 0) as events_count_version,
        
        COUNT_IF(events_count_all > 0) / COUNT(*) as has_events_all,
        COUNT_IF(events_count_version > 0) / COUNT(*) as has_events_version,
        COUNT_IF(
            'reset_sdk.entry_point.do_ready_init' IN event_list_uniq
        ) / COUNT(*) as ready,
        COUNT_IF(
            'passport_cross_login.start' IN event_list_uniq
        ) / COUNT(*) as cross_login_start,
        COUNT_IF(
            'passport_cross_login.success' IN event_list_uniq
        ) / COUNT(*) as cross_login_success,
        COUNT_IF(
            'passport_cross_login.success' IN event_list_uniq
            OR 
            (
                'passport_cross_login.no_session' IN event_list_uniq
                AND cross_login_permission == false
            )
        ) / COUNT(*) as cross_login_success_or_no_session_permission_false,
        COUNT_IF(
            'network.connected.first_time' IN event_list_uniq
        ) / COUNT(*) as connected_first_time,
        COUNT_IF(
            'network.ping' IN event_list_uniq
        ) / COUNT(*) as network_ping,
        COUNT_IF(
            'data_sync_completed' IN event_list_uniq
        ) / COUNT(*) as data_sync_completed
    FROM
    (
        SELECT
            fielddate,
            head_id,
            car_id,
            city,
            model,
            cross_login_permission,
            order_created_at,
            app_version,
            
            COUNT_IF(event_name != '') as events_count_all,
            COUNT_IF(
                event_name != '' 
                AND app_id == $LAUNCHER_APP_ID 
                AND $launcher_version_to_int(logs.app_version_launcher) >= 
                    $launcher_version_to_int(app_version)
            ) as events_count_version,
            AGGREGATE_LIST_DISTINCT(IF(
                app_id == $LAUNCHER_APP_ID 
                AND $launcher_version_to_int(logs.app_version_launcher) >= 
                    $launcher_version_to_int(app_version)
                AND (
                    event_name IN (
                        'reset_sdk.entry_point.do_ready_init',
                        'passport_cross_login.start',
                        'passport_cross_login.success',
                        'passport_cross_login.no_session',
                        'network.connected.first_time',
                        'data_sync_completed'
                    )
                    OR event_name == 'network.ping' AND CAST(event_value['ping_millis'] as Int64) > 0
                ),
                event_name,
                ''
            )) as event_list_uniq
        FROM
            $logs_with_drive_sessions as logs
            LEFT JOIN $cars_attr as cars ON logs.car_id == cars.car_id
            CROSS JOIN $app_versions as vers
        GROUP BY
            $round_period_str(
                CAST(DateTime::FromSeconds(CAST(order_created_at as Uint32)) as Date), 
                $scale
            ) as fielddate,
            vers.app_version_launcher as app_version,
            logs.head_id as head_id,
            logs.car_id as car_id,
            logs.order_created_at as order_created_at,
            logs.cross_login_permission as cross_login_permission,
            cars.city as city,
            cars.model as model
    )
    FLATTEN LIST BY (
        AsList($TOTAL_VALUE, city) as city,
        AsList($TOTAL_VALUE, model) as model
    )
    GROUP BY
        fielddate,
        app_version,
        city,
        model;
END DEFINE;