PRAGMA yt.InferSchema = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.AutoConvert;

-- CONSTANTS --

$API_KEYS = ("30488",);

-- INCLUDES --

PRAGMA Library("metrika_mobile_log.sql");
IMPORT metrika_mobile_log SYMBOLS 
    $metrika_mobile_log;

PRAGMA Library("common.sql");
IMPORT common SYMBOLS 
    $date_format,
    $regionToCountry,
    $regionToArea,
    $round_period_str;

PRAGMA Library("report.sql");
IMPORT report SYMBOLS
    $TOTAL_VALUE;

-- PRAGMA yson.DisableStrict;

-- OPERATIONS -- 
use hahn;

DEFINE SUBQUERY $__REPORT__($scale, $start_date, $end_date) AS
    $logs = (
        SELECT
            $round_period_str(receive_date, $scale) as fielddate,
            region_id,
            device_id,
            event_name,
            event_value['manufacturer-uuid'] as man_uuid
        FROM
            $metrika_mobile_log(
                $API_KEYS, 
                $start_date, $end_date
            )
        WHERE
            $regionToCountry(region_id) == 225
            AND String::ToLower(model) == 'mtrx_avn'
    );
    
    $active_day_devids = (
        SELECT
            device_id || fielddate
        FROM
            $logs
        WHERE
            event_name IN ('guidance.ping', 'guidance.freedrive_ping')
        GROUP BY device_id, fielddate
    );
    
    SELECT
        fielddate,
        region,
        man_uuid,
        SOME(device_id) as device_id,
        MAX((device_id || fielddate) IN $active_day_devids) as has_ping
    FROM
        $logs
    FLATTEN BY (
        ListUniq(AsList(
            $TOTAL_VALUE,
            CAST($regionToCountry(region_id) as String),
            CAST($regionToArea(region_id) as String)
        )) as region
    )
    WHERE
        event_name == 'application.device-info'
    GROUP BY 
        fielddate,
        region,
        man_uuid
    ORDER BY
        fielddate,
        region,
        man_uuid
END DEFINE;
