PRAGMA yt.InferSchema = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;

-- CONSTANTS --

$API_KEYS = (
    "517959",  -- Launcher
    "2940673", -- UMA
    "2950450", -- Homescreen  
    "3115138", -- Alice 
    "3281023", -- HealthApp
    "3362689", -- NavigationBar
    "3293308", -- Weather
    "3239212", -- Dialer
    "3239218", -- Notifications
    "3554191", -- Systemui
    "3322075" -- Settings
);

$TIMEZONE = 'Europe/Moscow';

-- INCLUDES --

PRAGMA Library("metrika_mobile_log.sql");
IMPORT metrika_mobile_log SYMBOLS 
    $metrika_mobile_log;

PRAGMA Library("common.sql");
IMPORT common SYMBOLS 
    $round_period_str;

-- OPERATIONS -- 
use hahn;

$launcher_version_extractor = ($v) -> {
    $extractor = Re2::Capture("\\d+.\\d+.\\d+");
    RETURN $extractor($v)._0;
};

DEFINE SUBQUERY $__REPORT__($scale, $start_date, $end_date) AS
    $logs = (
        SELECT
            $round_period_str(
                AddTimezone(
                    DateTime::FromSeconds(event_timestamp), 
                    $TIMEZONE
                ), 
                $scale
            ) as fielddate,
            String::ToUpper(report_environment['HeadId']) as head_id,
            device_id,
            $launcher_version_extractor(app_version_raw) as version,
            event_value['PROCESS_NAME'] as process_name,
            event_value['DURATION_TIME'] as duration_time
        FROM
            $metrika_mobile_log(
                $API_KEYS, 
                $start_date, $end_date
            )
        WHERE
            event_date BETWEEN $start_date AND $end_date
            AND event_name == 'application.onCreate'
            AND String::ToLower(report_environment['IsBooter']) == 'false'
    );

    SELECT
        fielddate,
        head_id,
        device_id,
        version,
        process_name,
        duration_time
    FROM 
        $logs;
END DEFINE;
