PRAGMA yt.InferSchema = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.AutoConvert;

-- CONSTANTS --

$API_KEYS = ("30488",);

-- INCLUDES --

PRAGMA Library("metrika_mobile_log.sql");
IMPORT metrika_mobile_log SYMBOLS 
    $metrika_mobile_log;

PRAGMA Library("common.sql");
IMPORT common SYMBOLS 
    $date_format,
    $regionToCountry,
    $regionToArea,
    $round_period_str;

PRAGMA Library("report.sql");
IMPORT report SYMBOLS
    $TOTAL_VALUE;

-- PRAGMA yson.DisableStrict;

-- OPERATIONS -- 
use hahn;

$get_projected_model = ($event_value) -> {
    $jlr = ($ev, $values) -> {
        RETURN (
            'InControlTouchPRO' IN $values 
            OR $ev['com.bosch.myspin.EXTRA_IVI_FIRMWARE_VERSION_F'] ILIKE '%C01.01.10 P01.01.03%'
        )
    };
    
    $renault = ($values) -> {
        RETURN (
            'Renault' IN $values
            OR 'Linux Gen3 iMX6' IN $values
        )
    };

    $daimler = ($values) -> {
        RETURN ('Mercedes-Benz Link' IN $values)
    };
    
    $avtovaz = ($values) -> {
        RETURN (
            'Avtovaz' IN $values
            OR 'Itelma Device' IN $values
        )
    };
    
    $nissan = ($values) -> {
        RETURN (
            'NISSAN' IN $values
        )
    };
    
    $values = DictPayloads($event_value);
    
    -- THE ORDER IS IMPORTANT!!! --
    RETURN IF($nissan($values), 'Nissan',
           IF($daimler($values), 'Daimler',
           IF($avtovaz($values), 'Avtovaz',
           IF($renault($values), 'Renault',
           IF($jlr($event_value, $values), 'JLR',
           'else'
    )))));
};

DEFINE SUBQUERY $__REPORT__($scale, $start_date, $end_date) AS
    $logs = (
        SELECT
            $round_period_str(receive_date, $scale) as fielddate,
            region_id,
            platform,
            device_id,
            event_name,
            $get_projected_model(event_value) as projected_model
        FROM
            $metrika_mobile_log(
                $API_KEYS, 
                $start_date, $end_date
            )
        WHERE
            event_name == 'myspin.ivi-information'
    );

    SELECT
        fielddate,
        region,
        platform,
        projected_model,
        device_id
    FROM
        $logs
    FLATTEN BY (
        ListUniq(AsList(
            $TOTAL_VALUE,
            CAST($regionToCountry(region_id) AS String),
            CAST($regionToArea(region_id) AS String)
        )) AS region,
        ListUniq(AsList(
            $TOTAL_VALUE,
            platform
        )) AS platform
    )
    GROUP BY 
        fielddate,
        region,
        platform,
        projected_model,
        device_id
    ORDER BY
        fielddate,
        region,
        platform
END DEFINE;
