PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.AutoConvert;

-- CONSTANTS --

$API_KEYS = ("30488",);

$MAX_UNIQ_ATTR_VALUES = 20;
$MAX_EVENT_NAME_LENGTH = 50;
$MAX_EVENT_ATTR_LENGTH = 50;

-- INCLUDES --

PRAGMA Library("metrika_mobile_log.sql");
IMPORT metrika_mobile_log SYMBOLS 
    $metrika_mobile_log,
    $versionToInt;

PRAGMA Library("common.sql");
IMPORT common SYMBOLS
    $regionToCountry,
    $regionToArea,
    $round_period_str,
    $event_filter;
    
PRAGMA Library("report.sql");
IMPORT report SYMBOLS
    $TOTAL_VALUE;

-- OPERATIONS -- 
use hahn;

DEFINE SUBQUERY $__REPORT__($scale, $start_date, $end_date) AS
    $logs = (
        SELECT
            $round_period_str(receive_date, $scale) as fielddate,
            region_id,
            platform,
            app_version,
            session_type,
            device_id,
            event_name,
            event_value
        FROM
            $metrika_mobile_log(
                $API_KEYS, 
                $start_date, $end_date
            )
    );
    
    $flatten_event_value_logs = (
        SELECT
            fielddate,
            region_id,
            platform,
            app_version,
            session_type,
            device_id,
            event_name,
            attr.0 ?? "" as attr_key,
            attr.1 ?? "" as attr_value
        FROM
            $logs
        FLATTEN DICT BY (
            SetUnion(
                event_value,
                AsDict(AsTuple($TOTAL_VALUE, $TOTAL_VALUE)),
                ($_, $a, $b) -> { RETURN $a ?? $b}
            ) as attr
        )
    );
    
    $keys_black_list = (
        SELECT
            event_name || attr_key 
        FROM
            $flatten_event_value_logs
        GROUP BY
            event_name, 
            attr_key
        HAVING
            ListLength(AGGREGATE_LIST_DISTINCT(
                attr_value, 
                UNWRAP(CAST($MAX_UNIQ_ATTR_VALUES + 1 as Uint32))
            )) > $MAX_UNIQ_ATTR_VALUES
    );
    
    $filtered_events = (
        SELECT 
            *
        FROM
            $flatten_event_value_logs
        WHERE
            $event_filter(event_name, $MAX_EVENT_NAME_LENGTH)
            AND $event_filter(attr_key, $MAX_EVENT_ATTR_LENGTH)
            AND event_name || attr_key NOT IN COMPACT $keys_black_list
    );
        
    SELECT 
        fielddate,
        region,
        platform,
        session_type,
        event_name,
        attr_key,
        attr_value,
        
        COUNT(DISTINCT device_id) as users,
        COUNT(*) as events
    FROM
    (
        SELECT
            fielddate,
            region,
            platform,
            session_type,
            device_id,
            event_name,
            attr_key,
            attr_value
        FROM
            $filtered_events
        FLATTEN LIST BY (
            ListUniq(AsList(
                $TOTAL_VALUE,
                CAST($regionToCountry(region_id) as String),
                CAST($regionToArea(region_id) as String)
            )) as region,
            ListUniq(AsList(
                $TOTAL_VALUE,
                platform
            )) as platform,
            ListUniq(AsList(
                $TOTAL_VALUE,
                session_type
            )) as session_type,
            ListUniq(AsList(
                $TOTAL_VALUE,
                event_name
            )) as event_name
        )
        WHERE
            (
                event_name != $TOTAL_VALUE OR attr_key == $TOTAL_VALUE
            )
            AND region != '' AND region IS NOT NULL
    )
    GROUP BY
        fielddate,
        region,
        platform,
        session_type,
        event_name,
        attr_key,
        attr_value
END DEFINE;