-- FUNCTIONS --
$regionTo = ($id, $type) -> {
    RETURN Geo::RoundRegionById($id, $type).id;
};
$regionToCity = ($id) -> { RETURN $regionTo($id, "city") };
$regionToArea = ($id) -> { RETURN $regionTo($id, "region") };
$regionToCountry = ($id) -> { RETURN $regionTo($id, "country") };

$date_format = DateTime::Format("%Y-%m-%d");
$event_match = Re2::Match("^[0-9A-Za-z_\\-\\.]+$");
$event_filter = ($event, $max_length) -> {
    RETURN IF(LEN($event) <= $max_length,
        $event_match($event),
        False
    );
};

$round_period = ($date, $scale) -> {
    RETURN CASE $scale 
        WHEN "d" THEN DateTime::StartOfDay($date)
        WHEN "w" THEN DateTime::StartOfWeek($date)
        WHEN "m" THEN DateTime::StartOfMonth($date)
        WHEN "q" THEN DateTime::StartOfQuarter($date)
        WHEN "y" THEN DateTime::StartOfYear($date)
        ELSE $date
    END;
};

$round_period_str = ($date, $scale) -> {
    RETURN $date_format($round_period($date, $scale));
};

EXPORT 
    $date_format,
    $event_match,
    $event_filter,
    $regionTo,
    $regionToCity,
    $regionToArea,
    $regionToCountry,
    $round_period,
    $round_period_str;