use hahn;

$date_format = DateTime::Format("%Y-%m-%d");

$LOG_PATH = "//home/maps/automotive/drive_imports/user_sessions";

DEFINE SUBQUERY $drive_user_sessions($start_date, $end_date) AS 
    SELECT DISTINCT
        order_created_at,
        order_completed_at,
        engine_on,
        engine_off,
        lat_on,
        lon_on,
        lat_off,
        lon_off,
        uid,
        car_id,
        imei,
        not cross_login as cross_login_permission, 
        is_public_user,
        String::ToUpper(UNWRAP(head_id.2)) as head_id
    FROM RANGE($LOG_PATH, $date_format($start_date), $date_format($end_date))
    FLATTEN BY (
        ListMap(
            Yson::ConvertToList(head_id),
            ($x) -> {
                RETURN AsTuple(
                    Yson::LookupInt64($x, 'add', Yson::Options(false as Strict)),
                    Yson::LookupInt64($x, 'remove', Yson::Options(false as Strict)),
                    Yson::ConvertToString($x.head_id)
                )
            }
        ) as head_id
    )
    WHERE
        head_id.0 <= order_created_at 
        AND (
            head_id.1 IS NULL
            OR order_completed_at <= head_id.1
        )
END DEFINE;

EXPORT 
    $drive_user_sessions;
