use hahn;

PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.AutoConvert;

$date_format = DateTime::Format("%Y-%m-%d");

$android_version_extractor = ($v) -> {
    $extractor = Re2::Capture("\\d+.\\d+");
    RETURN $extractor($v)._0;
};
$ios_version_extractor = ($v) -> {
    $extractor = Re2::Capture("(\\d+)(\\d{2})");
    $v_parts = $extractor($v);
    
    RETURN IF(LENGTH($v) > 2, $v_parts._1 || "." || $v_parts._2, $v);
};
$versionToInt = ($v) -> {
    $cap = Re2::Capture("(\\d+).(\\d+)");
    RETURN CAST($cap($v)._1 as Int32) * 1000 + CAST($cap($v)._2 as Int32);
};

$LOG_PATH = "//home/logfeller/logs/metrika-mobile-log/1d";

$NEW_LOG_PATH = "//logs/appmetrica-yandex-events/1d";
$NEW_NAVI_LOG_PATH = "//home/logfeller/logs/navi-metrika-mobile-log/1d";

$PLATFORM_LIST = ('android', 'iOS');

$_report_environment_as_string_dict_new = ($env_keys, $env_values) -> {
    $env_dict = ToDict(ListZip($env_keys, $env_values));
    RETURN $env_dict;
};


DEFINE SUBQUERY $new_metrika_mobile_log($api_keys, $start_date, $end_date) AS 
    SELECT
        CAST(EventTimestamp as Uint32) as event_timestamp,
        CAST(
            DateTime::FromSeconds(CAST(EventTimestamp as Uint32)) as Date
        ) as event_date,
        CAST(ReceiveTimestamp as Uint32) as receive_timestamp,
        CAST(
            DateTime::FromSeconds(CAST(ReceiveTimestamp as Uint32)) as Date
        ) as receive_date,
        APIKey as api_key,
        AppID as app_id,
        CAST(RegionID as Int32) as region_id,
        EventName as event_name,
        EventNumber as event_number,
        AppPlatform as platform,
        DeviceID as device_id,
        AccountID as puid,
        ADVID ?? OriginalDeviceID as adv_id,
        `UUID` as `uuid`,
        SessionID as session_id,
        SessionType as session_type,
        Yson::ConvertToStringDict(CAST(EventValue as JSON)) as event_value,
        EventValue as event_value_raw,
        IF(AppPlatform == 'android',
            $android_version_extractor(AppVersionName),
            $ios_version_extractor(AppVersionName)
        ) as app_version,
        AppVersionName as app_version_raw,
        Model as model,
        Manufacturer as manufacturer,
        $_report_environment_as_string_dict_new(
            ReportEnvironment_Keys, 
            ReportEnvironment_Values
        ) as report_environment
    FROM
    (
        SELECT
            *
        FROM RANGE($NEW_LOG_PATH, $date_format($start_date), $date_format($end_date))
        UNION ALL
        SELECT
            *
        FROM RANGE($NEW_NAVI_LOG_PATH, $date_format($start_date), $date_format($end_date))
    )
    WHERE
        APIKey IN $api_keys
        AND EventType == 4
        AND EventName IS NOT NULL
        AND AppPlatform IN $PLATFORM_LIST
END DEFINE;


-- DEPRECATED ------------------------------------------------------------------------

$_report_environment_as_string_dict = ($keys_field, $values_field) -> {
    $env_keys = Yson::ConvertToStringList(CAST($keys_field as Json));
    $env_values = Yson::ConvertToStringList(CAST($values_field as Json));
    $env_dict = ToDict(ListZip($env_keys, $env_values));
    RETURN $env_dict;
};

DEFINE SUBQUERY $metrika_mobile_log($api_keys, $start_date, $end_date) AS 
    SELECT
        CAST(EventTimestamp as Uint32) as event_timestamp,
        CAST(
            DateTime::FromSeconds(CAST(EventTimestamp as Uint32)) as Date
        ) as event_date,
        CAST(ReceiveTimestamp as Uint32) as receive_timestamp,
        CAST(
            DateTime::FromSeconds(CAST(ReceiveTimestamp as Uint32)) as Date
        ) as receive_date,
        APIKey as api_key,
        AppID as app_id,
        CAST(RegionID as Int32) as region_id,
        EventName as event_name,
        EventNumber as event_number,
        AppPlatform as platform,
        DeviceID as device_id,
        AccountID as puid,
        ADVID ?? OriginalDeviceID as adv_id,
        `UUID` as `uuid`,
        SessionID as session_id,
        SessionType as session_type,
        Yson::ConvertToStringDict(CAST(EventValue as JSON)) as event_value,
        EventValue as event_value_raw,
        IF(AppPlatform == 'android',
            $android_version_extractor(AppVersionName),
            $ios_version_extractor(AppVersionName)
        ) as app_version,
        AppVersionName as app_version_raw,
        Model as model,
        Manufacturer as manufacturer,
        $_report_environment_as_string_dict(
            ReportEnvironment_Keys, 
            ReportEnvironment_Values
        ) as report_environment
    FROM RANGE($LOG_PATH, $date_format($start_date), $date_format($end_date))
    WHERE
        APIKey IN $api_keys
        AND EventType == "EVENT_CLIENT"
        AND EventName IS NOT NULL
        AND AppPlatform IN $PLATFORM_LIST
END DEFINE;

------------------------------------------------------------------------------

EXPORT 
    $metrika_mobile_log,
    $new_metrika_mobile_log,
    $versionToInt,
    $PLATFORM_LIST;
